﻿// <auto-generated />

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using Microsoft.AspNetCore.Razor.Language.Legacy;


namespace Microsoft.AspNetCore.Razor.Language.Syntax
{


  internal abstract partial class RazorBlockSyntax : RazorSyntaxNode
  {
    internal RazorBlockSyntax(GreenNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    public abstract SyntaxList<RazorSyntaxNode> Children { get; }
    public RazorBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children) => WithChildrenCore(children);
    internal abstract RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children);

    public RazorBlockSyntax AddChildren(params RazorSyntaxNode[] items) => AddChildrenCore(items);
    internal abstract RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items);
  }

  internal sealed partial class RazorDocumentSyntax : RazorSyntaxNode
  {
    private RazorBlockSyntax _document;
    private SyntaxToken _endOfFile;

    internal RazorDocumentSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public RazorBlockSyntax Document 
    {
        get
        {
            return GetRedAtZero(ref _document);
        }
    }

    public SyntaxToken EndOfFile 
    {
        get
        {
            return GetRed(ref _endOfFile, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _document);
            case 1: return GetRed(ref _endOfFile, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _document;
            case 1: return _endOfFile;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorDocument(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorDocument(this);
    }

    public RazorDocumentSyntax Update(RazorBlockSyntax document, SyntaxToken endOfFile)
    {
        if (document != Document || endOfFile != EndOfFile)
        {
            var newNode = SyntaxFactory.RazorDocument(document, endOfFile);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public RazorDocumentSyntax WithDocument(RazorBlockSyntax document)
    {
        return Update(document, EndOfFile);
    }

    public RazorDocumentSyntax WithEndOfFile(SyntaxToken endOfFile)
    {
        return Update(Document, endOfFile);
    }
  }

  internal sealed partial class RazorCommentBlockSyntax : RazorSyntaxNode
  {
    private SyntaxToken _startCommentTransition;
    private SyntaxToken _startCommentStar;
    private SyntaxToken _comment;
    private SyntaxToken _endCommentStar;
    private SyntaxToken _endCommentTransition;

    internal RazorCommentBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken StartCommentTransition 
    {
        get
        {
            return GetRedAtZero(ref _startCommentTransition);
        }
    }

    public SyntaxToken StartCommentStar 
    {
        get
        {
            return GetRed(ref _startCommentStar, 1);
        }
    }

    public SyntaxToken Comment 
    {
        get
        {
            return GetRed(ref _comment, 2);
        }
    }

    public SyntaxToken EndCommentStar 
    {
        get
        {
            return GetRed(ref _endCommentStar, 3);
        }
    }

    public SyntaxToken EndCommentTransition 
    {
        get
        {
            return GetRed(ref _endCommentTransition, 4);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _startCommentTransition);
            case 1: return GetRed(ref _startCommentStar, 1);
            case 2: return GetRed(ref _comment, 2);
            case 3: return GetRed(ref _endCommentStar, 3);
            case 4: return GetRed(ref _endCommentTransition, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _startCommentTransition;
            case 1: return _startCommentStar;
            case 2: return _comment;
            case 3: return _endCommentStar;
            case 4: return _endCommentTransition;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorCommentBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorCommentBlock(this);
    }

    public RazorCommentBlockSyntax Update(SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
    {
        if (startCommentTransition != StartCommentTransition || startCommentStar != StartCommentStar || comment != Comment || endCommentStar != EndCommentStar || endCommentTransition != EndCommentTransition)
        {
            var newNode = SyntaxFactory.RazorCommentBlock(startCommentTransition, startCommentStar, comment, endCommentStar, endCommentTransition);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public RazorCommentBlockSyntax WithStartCommentTransition(SyntaxToken startCommentTransition)
    {
        return Update(startCommentTransition, StartCommentStar, Comment, EndCommentStar, EndCommentTransition);
    }

    public RazorCommentBlockSyntax WithStartCommentStar(SyntaxToken startCommentStar)
    {
        return Update(StartCommentTransition, startCommentStar, Comment, EndCommentStar, EndCommentTransition);
    }

    public RazorCommentBlockSyntax WithComment(SyntaxToken comment)
    {
        return Update(StartCommentTransition, StartCommentStar, comment, EndCommentStar, EndCommentTransition);
    }

    public RazorCommentBlockSyntax WithEndCommentStar(SyntaxToken endCommentStar)
    {
        return Update(StartCommentTransition, StartCommentStar, Comment, endCommentStar, EndCommentTransition);
    }

    public RazorCommentBlockSyntax WithEndCommentTransition(SyntaxToken endCommentTransition)
    {
        return Update(StartCommentTransition, StartCommentStar, Comment, EndCommentStar, endCommentTransition);
    }
  }

  internal sealed partial class RazorMetaCodeSyntax : RazorSyntaxNode
  {
    private SyntaxNode _metaCode;

    internal RazorMetaCodeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<SyntaxToken> MetaCode 
    {
        get
        {
            return new SyntaxList<SyntaxToken>(GetRed(ref _metaCode, 0));
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.RazorMetaCodeSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _metaCode);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _metaCode;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorMetaCode(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorMetaCode(this);
    }

    public RazorMetaCodeSyntax Update(SyntaxList<SyntaxToken> metaCode, ISpanChunkGenerator chunkGenerator)
    {
        if (metaCode != MetaCode || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.RazorMetaCode(metaCode, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public RazorMetaCodeSyntax WithMetaCode(SyntaxList<SyntaxToken> metaCode)
    {
        return Update(metaCode, ChunkGenerator);
    }

    public RazorMetaCodeSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(MetaCode, chunkGenerator);
    }

    public RazorMetaCodeSyntax AddMetaCode(params SyntaxToken[] items)
    {
        return WithMetaCode(this.MetaCode.AddRange(items));
    }
  }

  internal sealed partial class GenericBlockSyntax : RazorBlockSyntax
  {
    private SyntaxNode _children;

    internal GenericBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _children);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitGenericBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitGenericBlock(this);
    }

    public GenericBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.GenericBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new GenericBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children)
    {
        return Update(children);
    }
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new GenericBlockSyntax AddChildren(params RazorSyntaxNode[] items)
    {
        return WithChildren(this.Children.AddRange(items));
    }
  }

  internal sealed partial class UnclassifiedTextLiteralSyntax : RazorSyntaxNode
  {
    private SyntaxNode _literalTokens;

    internal UnclassifiedTextLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<SyntaxToken> LiteralTokens 
    {
        get
        {
            return new SyntaxList<SyntaxToken>(GetRed(ref _literalTokens, 0));
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.UnclassifiedTextLiteralSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _literalTokens);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitUnclassifiedTextLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitUnclassifiedTextLiteral(this);
    }

    public UnclassifiedTextLiteralSyntax Update(SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.UnclassifiedTextLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public UnclassifiedTextLiteralSyntax WithLiteralTokens(SyntaxList<SyntaxToken> literalTokens)
    {
        return Update(literalTokens, ChunkGenerator);
    }

    public UnclassifiedTextLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(LiteralTokens, chunkGenerator);
    }

    public UnclassifiedTextLiteralSyntax AddLiteralTokens(params SyntaxToken[] items)
    {
        return WithLiteralTokens(this.LiteralTokens.AddRange(items));
    }
  }

  internal abstract partial class MarkupSyntaxNode : RazorSyntaxNode
  {
    internal MarkupSyntaxNode(GreenNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  internal sealed partial class MarkupBlockSyntax : RazorBlockSyntax
  {
    private SyntaxNode _children;

    internal MarkupBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _children);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupBlock(this);
    }

    public MarkupBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new MarkupBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children)
    {
        return Update(children);
    }
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new MarkupBlockSyntax AddChildren(params RazorSyntaxNode[] items)
    {
        return WithChildren(this.Children.AddRange(items));
    }
  }

  internal sealed partial class MarkupTransitionSyntax : MarkupSyntaxNode
  {
    private SyntaxNode _transitionTokens;

    internal MarkupTransitionSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<SyntaxToken> TransitionTokens 
    {
        get
        {
            return new SyntaxList<SyntaxToken>(GetRed(ref _transitionTokens, 0));
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.MarkupTransitionSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _transitionTokens);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _transitionTokens;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTransition(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTransition(this);
    }

    public MarkupTransitionSyntax Update(SyntaxList<SyntaxToken> transitionTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (transitionTokens != TransitionTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupTransition(transitionTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupTransitionSyntax WithTransitionTokens(SyntaxList<SyntaxToken> transitionTokens)
    {
        return Update(transitionTokens, ChunkGenerator);
    }

    public MarkupTransitionSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(TransitionTokens, chunkGenerator);
    }

    public MarkupTransitionSyntax AddTransitionTokens(params SyntaxToken[] items)
    {
        return WithTransitionTokens(this.TransitionTokens.AddRange(items));
    }
  }

  internal sealed partial class MarkupTextLiteralSyntax : MarkupSyntaxNode
  {
    private SyntaxNode _literalTokens;

    internal MarkupTextLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<SyntaxToken> LiteralTokens 
    {
        get
        {
            return new SyntaxList<SyntaxToken>(GetRed(ref _literalTokens, 0));
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.MarkupTextLiteralSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _literalTokens);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTextLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTextLiteral(this);
    }

    public MarkupTextLiteralSyntax Update(SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupTextLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupTextLiteralSyntax WithLiteralTokens(SyntaxList<SyntaxToken> literalTokens)
    {
        return Update(literalTokens, ChunkGenerator);
    }

    public MarkupTextLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(LiteralTokens, chunkGenerator);
    }

    public MarkupTextLiteralSyntax AddLiteralTokens(params SyntaxToken[] items)
    {
        return WithLiteralTokens(this.LiteralTokens.AddRange(items));
    }
  }

  internal sealed partial class MarkupEphemeralTextLiteralSyntax : MarkupSyntaxNode
  {
    private SyntaxNode _literalTokens;

    internal MarkupEphemeralTextLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<SyntaxToken> LiteralTokens 
    {
        get
        {
            return new SyntaxList<SyntaxToken>(GetRed(ref _literalTokens, 0));
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.MarkupEphemeralTextLiteralSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _literalTokens);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupEphemeralTextLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupEphemeralTextLiteral(this);
    }

    public MarkupEphemeralTextLiteralSyntax Update(SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupEphemeralTextLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupEphemeralTextLiteralSyntax WithLiteralTokens(SyntaxList<SyntaxToken> literalTokens)
    {
        return Update(literalTokens, ChunkGenerator);
    }

    public MarkupEphemeralTextLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(LiteralTokens, chunkGenerator);
    }

    public MarkupEphemeralTextLiteralSyntax AddLiteralTokens(params SyntaxToken[] items)
    {
        return WithLiteralTokens(this.LiteralTokens.AddRange(items));
    }
  }

  internal sealed partial class MarkupCommentBlockSyntax : RazorBlockSyntax
  {
    private SyntaxNode _children;

    internal MarkupCommentBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _children);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupCommentBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupCommentBlock(this);
    }

    public MarkupCommentBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupCommentBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new MarkupCommentBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children)
    {
        return Update(children);
    }
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new MarkupCommentBlockSyntax AddChildren(params RazorSyntaxNode[] items)
    {
        return WithChildren(this.Children.AddRange(items));
    }
  }

  internal sealed partial class MarkupMinimizedAttributeBlockSyntax : MarkupSyntaxNode
  {
    private MarkupTextLiteralSyntax _namePrefix;
    private MarkupTextLiteralSyntax _name;

    internal MarkupMinimizedAttributeBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix 
    {
        get
        {
            return GetRedAtZero(ref _namePrefix);
        }
    }

    public MarkupTextLiteralSyntax Name 
    {
        get
        {
            return GetRed(ref _name, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _namePrefix);
            case 1: return GetRed(ref _name, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupMinimizedAttributeBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupMinimizedAttributeBlock(this);
    }

    public MarkupMinimizedAttributeBlockSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        if (namePrefix != NamePrefix || name != Name)
        {
            var newNode = SyntaxFactory.MarkupMinimizedAttributeBlock(namePrefix, name);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupMinimizedAttributeBlockSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix)
    {
        return Update(namePrefix, Name);
    }

    public MarkupMinimizedAttributeBlockSyntax WithName(MarkupTextLiteralSyntax name)
    {
        return Update(NamePrefix, name);
    }

    public MarkupMinimizedAttributeBlockSyntax AddNameLiteralTokens(params SyntaxToken[] items)
    {
        return this.WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
    }
  }

  internal sealed partial class MarkupAttributeBlockSyntax : MarkupSyntaxNode
  {
    private MarkupTextLiteralSyntax _namePrefix;
    private MarkupTextLiteralSyntax _name;
    private MarkupTextLiteralSyntax _nameSuffix;
    private SyntaxToken _equalsToken;
    private MarkupTextLiteralSyntax _valuePrefix;
    private RazorBlockSyntax _value;
    private MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupAttributeBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix 
    {
        get
        {
            return GetRedAtZero(ref _namePrefix);
        }
    }

    public MarkupTextLiteralSyntax Name 
    {
        get
        {
            return GetRed(ref _name, 1);
        }
    }

    public MarkupTextLiteralSyntax NameSuffix 
    {
        get
        {
            return GetRed(ref _nameSuffix, 2);
        }
    }

    public SyntaxToken EqualsToken 
    {
        get
        {
            return GetRed(ref _equalsToken, 3);
        }
    }

    public MarkupTextLiteralSyntax ValuePrefix 
    {
        get
        {
            return GetRed(ref _valuePrefix, 4);
        }
    }

    public RazorBlockSyntax Value 
    {
        get
        {
            return GetRed(ref _value, 5);
        }
    }

    public MarkupTextLiteralSyntax ValueSuffix 
    {
        get
        {
            return GetRed(ref _valueSuffix, 6);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _namePrefix);
            case 1: return GetRed(ref _name, 1);
            case 2: return GetRed(ref _nameSuffix, 2);
            case 3: return GetRed(ref _equalsToken, 3);
            case 4: return GetRed(ref _valuePrefix, 4);
            case 5: return GetRed(ref _value, 5);
            case 6: return GetRed(ref _valueSuffix, 6);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _name;
            case 2: return _nameSuffix;
            case 3: return _equalsToken;
            case 4: return _valuePrefix;
            case 5: return _value;
            case 6: return _valueSuffix;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupAttributeBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupAttributeBlock(this);
    }

    public MarkupAttributeBlockSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || name != Name || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupAttributeBlock(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupAttributeBlockSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix)
    {
        return Update(namePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupAttributeBlockSyntax WithName(MarkupTextLiteralSyntax name)
    {
        return Update(NamePrefix, name, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupAttributeBlockSyntax WithNameSuffix(MarkupTextLiteralSyntax nameSuffix)
    {
        return Update(NamePrefix, Name, nameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupAttributeBlockSyntax WithEqualsToken(SyntaxToken equalsToken)
    {
        return Update(NamePrefix, Name, NameSuffix, equalsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupAttributeBlockSyntax WithValuePrefix(MarkupTextLiteralSyntax valuePrefix)
    {
        return Update(NamePrefix, Name, NameSuffix, EqualsToken, valuePrefix, Value, ValueSuffix);
    }

    public MarkupAttributeBlockSyntax WithValue(RazorBlockSyntax value)
    {
        return Update(NamePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, value, ValueSuffix);
    }

    public MarkupAttributeBlockSyntax WithValueSuffix(MarkupTextLiteralSyntax valueSuffix)
    {
        return Update(NamePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, Value, valueSuffix);
    }

    public MarkupAttributeBlockSyntax AddNameLiteralTokens(params SyntaxToken[] items)
    {
        return this.WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
    }
  }

  internal sealed partial class MarkupMiscAttributeContentSyntax : MarkupSyntaxNode
  {
    private SyntaxNode _children;

    internal MarkupMiscAttributeContentSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<RazorSyntaxNode> Children 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _children);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupMiscAttributeContent(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupMiscAttributeContent(this);
    }

    public MarkupMiscAttributeContentSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupMiscAttributeContent(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupMiscAttributeContentSyntax WithChildren(SyntaxList<RazorSyntaxNode> children)
    {
        return Update(children);
    }

    public MarkupMiscAttributeContentSyntax AddChildren(params RazorSyntaxNode[] items)
    {
        return WithChildren(this.Children.AddRange(items));
    }
  }

  internal sealed partial class MarkupLiteralAttributeValueSyntax : MarkupSyntaxNode
  {
    private MarkupTextLiteralSyntax _prefix;
    private MarkupTextLiteralSyntax _value;

    internal MarkupLiteralAttributeValueSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax Prefix 
    {
        get
        {
            return GetRedAtZero(ref _prefix);
        }
    }

    public MarkupTextLiteralSyntax Value 
    {
        get
        {
            return GetRed(ref _value, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _prefix);
            case 1: return GetRed(ref _value, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _prefix;
            case 1: return _value;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupLiteralAttributeValue(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupLiteralAttributeValue(this);
    }

    public MarkupLiteralAttributeValueSyntax Update(MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
    {
        if (prefix != Prefix || value != Value)
        {
            var newNode = SyntaxFactory.MarkupLiteralAttributeValue(prefix, value);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupLiteralAttributeValueSyntax WithPrefix(MarkupTextLiteralSyntax prefix)
    {
        return Update(prefix, Value);
    }

    public MarkupLiteralAttributeValueSyntax WithValue(MarkupTextLiteralSyntax value)
    {
        return Update(Prefix, value);
    }
  }

  internal sealed partial class MarkupDynamicAttributeValueSyntax : MarkupSyntaxNode
  {
    private MarkupTextLiteralSyntax _prefix;
    private RazorBlockSyntax _value;

    internal MarkupDynamicAttributeValueSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax Prefix 
    {
        get
        {
            return GetRedAtZero(ref _prefix);
        }
    }

    public RazorBlockSyntax Value 
    {
        get
        {
            return GetRed(ref _value, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _prefix);
            case 1: return GetRed(ref _value, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _prefix;
            case 1: return _value;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupDynamicAttributeValue(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupDynamicAttributeValue(this);
    }

    public MarkupDynamicAttributeValueSyntax Update(MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
    {
        if (prefix != Prefix || value != Value)
        {
            var newNode = SyntaxFactory.MarkupDynamicAttributeValue(prefix, value);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupDynamicAttributeValueSyntax WithPrefix(MarkupTextLiteralSyntax prefix)
    {
        return Update(prefix, Value);
    }

    public MarkupDynamicAttributeValueSyntax WithValue(RazorBlockSyntax value)
    {
        return Update(Prefix, value);
    }
  }

  internal sealed partial class MarkupElementSyntax : MarkupSyntaxNode
  {
    private MarkupStartTagSyntax _startTag;
    private SyntaxNode _body;
    private MarkupEndTagSyntax _endTag;

    internal MarkupElementSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupStartTagSyntax StartTag 
    {
        get
        {
            return GetRedAtZero(ref _startTag);
        }
    }

    public SyntaxList<RazorSyntaxNode> Body 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _body, 1));
        }
    }

    public MarkupEndTagSyntax EndTag 
    {
        get
        {
            return GetRed(ref _endTag, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _startTag);
            case 1: return GetRed(ref _body, 1);
            case 2: return GetRed(ref _endTag, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _startTag;
            case 1: return _body;
            case 2: return _endTag;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupElement(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupElement(this);
    }

    public MarkupElementSyntax Update(MarkupStartTagSyntax startTag, SyntaxList<RazorSyntaxNode> body, MarkupEndTagSyntax endTag)
    {
        if (startTag != StartTag || body != Body || endTag != EndTag)
        {
            var newNode = SyntaxFactory.MarkupElement(startTag, body, endTag);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupElementSyntax WithStartTag(MarkupStartTagSyntax startTag)
    {
        return Update(startTag, Body, EndTag);
    }

    public MarkupElementSyntax WithBody(SyntaxList<RazorSyntaxNode> body)
    {
        return Update(StartTag, body, EndTag);
    }

    public MarkupElementSyntax WithEndTag(MarkupEndTagSyntax endTag)
    {
        return Update(StartTag, Body, endTag);
    }

    public MarkupElementSyntax AddBody(params RazorSyntaxNode[] items)
    {
        return WithBody(this.Body.AddRange(items));
    }
  }

  internal sealed partial class MarkupStartTagSyntax : MarkupSyntaxNode
  {
    private SyntaxToken _openAngle;
    private SyntaxToken _bang;
    private SyntaxToken _name;
    private SyntaxNode _attributes;
    private SyntaxToken _forwardSlash;
    private SyntaxToken _closeAngle;

    internal MarkupStartTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenAngle 
    {
        get
        {
            return GetRedAtZero(ref _openAngle);
        }
    }

    public SyntaxToken Bang 
    {
        get
        {
            return GetRed(ref _bang, 1);
        }
    }

    public SyntaxToken Name 
    {
        get
        {
            return GetRed(ref _name, 2);
        }
    }

    public SyntaxList<RazorSyntaxNode> Attributes 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _attributes, 3));
        }
    }

    public SyntaxToken ForwardSlash 
    {
        get
        {
            return GetRed(ref _forwardSlash, 4);
        }
    }

    public SyntaxToken CloseAngle 
    {
        get
        {
            return GetRed(ref _closeAngle, 5);
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.MarkupStartTagSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _openAngle);
            case 1: return GetRed(ref _bang, 1);
            case 2: return GetRed(ref _name, 2);
            case 3: return GetRed(ref _attributes, 3);
            case 4: return GetRed(ref _forwardSlash, 4);
            case 5: return GetRed(ref _closeAngle, 5);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _openAngle;
            case 1: return _bang;
            case 2: return _name;
            case 3: return _attributes;
            case 4: return _forwardSlash;
            case 5: return _closeAngle;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupStartTag(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupStartTag(this);
    }

    public MarkupStartTagSyntax Update(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || bang != Bang || name != Name || attributes != Attributes || forwardSlash != ForwardSlash || closeAngle != CloseAngle || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupStartTag(openAngle, bang, name, attributes, forwardSlash, closeAngle, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupStartTagSyntax WithOpenAngle(SyntaxToken openAngle)
    {
        return Update(openAngle, Bang, Name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupStartTagSyntax WithBang(SyntaxToken bang)
    {
        return Update(OpenAngle, bang, Name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupStartTagSyntax WithName(SyntaxToken name)
    {
        return Update(OpenAngle, Bang, name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupStartTagSyntax WithAttributes(SyntaxList<RazorSyntaxNode> attributes)
    {
        return Update(OpenAngle, Bang, Name, attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupStartTagSyntax WithForwardSlash(SyntaxToken forwardSlash)
    {
        return Update(OpenAngle, Bang, Name, Attributes, forwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupStartTagSyntax WithCloseAngle(SyntaxToken closeAngle)
    {
        return Update(OpenAngle, Bang, Name, Attributes, ForwardSlash, closeAngle, ChunkGenerator);
    }

    public MarkupStartTagSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(OpenAngle, Bang, Name, Attributes, ForwardSlash, CloseAngle, chunkGenerator);
    }

    public MarkupStartTagSyntax AddAttributes(params RazorSyntaxNode[] items)
    {
        return WithAttributes(this.Attributes.AddRange(items));
    }
  }

  internal sealed partial class MarkupEndTagSyntax : MarkupSyntaxNode
  {
    private SyntaxToken _openAngle;
    private SyntaxToken _forwardSlash;
    private SyntaxToken _bang;
    private SyntaxToken _name;
    private MarkupMiscAttributeContentSyntax _miscAttributeContent;
    private SyntaxToken _closeAngle;

    internal MarkupEndTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenAngle 
    {
        get
        {
            return GetRedAtZero(ref _openAngle);
        }
    }

    public SyntaxToken ForwardSlash 
    {
        get
        {
            return GetRed(ref _forwardSlash, 1);
        }
    }

    public SyntaxToken Bang 
    {
        get
        {
            return GetRed(ref _bang, 2);
        }
    }

    public SyntaxToken Name 
    {
        get
        {
            return GetRed(ref _name, 3);
        }
    }

    public MarkupMiscAttributeContentSyntax MiscAttributeContent 
    {
        get
        {
            return GetRed(ref _miscAttributeContent, 4);
        }
    }

    public SyntaxToken CloseAngle 
    {
        get
        {
            return GetRed(ref _closeAngle, 5);
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.MarkupEndTagSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _openAngle);
            case 1: return GetRed(ref _forwardSlash, 1);
            case 2: return GetRed(ref _bang, 2);
            case 3: return GetRed(ref _name, 3);
            case 4: return GetRed(ref _miscAttributeContent, 4);
            case 5: return GetRed(ref _closeAngle, 5);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _openAngle;
            case 1: return _forwardSlash;
            case 2: return _bang;
            case 3: return _name;
            case 4: return _miscAttributeContent;
            case 5: return _closeAngle;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupEndTag(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupEndTag(this);
    }

    public MarkupEndTagSyntax Update(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || forwardSlash != ForwardSlash || bang != Bang || name != Name || miscAttributeContent != MiscAttributeContent || closeAngle != CloseAngle || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupEndTag(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupEndTagSyntax WithOpenAngle(SyntaxToken openAngle)
    {
        return Update(openAngle, ForwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupEndTagSyntax WithForwardSlash(SyntaxToken forwardSlash)
    {
        return Update(OpenAngle, forwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupEndTagSyntax WithBang(SyntaxToken bang)
    {
        return Update(OpenAngle, ForwardSlash, bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupEndTagSyntax WithName(SyntaxToken name)
    {
        return Update(OpenAngle, ForwardSlash, Bang, name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupEndTagSyntax WithMiscAttributeContent(MarkupMiscAttributeContentSyntax miscAttributeContent)
    {
        return Update(OpenAngle, ForwardSlash, Bang, Name, miscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupEndTagSyntax WithCloseAngle(SyntaxToken closeAngle)
    {
        return Update(OpenAngle, ForwardSlash, Bang, Name, MiscAttributeContent, closeAngle, ChunkGenerator);
    }

    public MarkupEndTagSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(OpenAngle, ForwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, chunkGenerator);
    }

    public MarkupEndTagSyntax AddMiscAttributeContentChildren(params RazorSyntaxNode[] items)
    {
        var _miscAttributeContent = this.MiscAttributeContent ?? SyntaxFactory.MarkupMiscAttributeContent();
        return this.WithMiscAttributeContent(_miscAttributeContent.WithChildren(_miscAttributeContent.Children.AddRange(items)));
    }
  }

  internal sealed partial class MarkupTagHelperElementSyntax : MarkupSyntaxNode
  {
    private MarkupTagHelperStartTagSyntax _startTag;
    private SyntaxNode _body;
    private MarkupTagHelperEndTagSyntax _endTag;

    internal MarkupTagHelperElementSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTagHelperStartTagSyntax StartTag 
    {
        get
        {
            return GetRedAtZero(ref _startTag);
        }
    }

    public SyntaxList<RazorSyntaxNode> Body 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _body, 1));
        }
    }

    public MarkupTagHelperEndTagSyntax EndTag 
    {
        get
        {
            return GetRed(ref _endTag, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _startTag);
            case 1: return GetRed(ref _body, 1);
            case 2: return GetRed(ref _endTag, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _startTag;
            case 1: return _body;
            case 2: return _endTag;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperElement(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperElement(this);
    }

    public MarkupTagHelperElementSyntax Update(MarkupTagHelperStartTagSyntax startTag, SyntaxList<RazorSyntaxNode> body, MarkupTagHelperEndTagSyntax endTag)
    {
        if (startTag != StartTag || body != Body || endTag != EndTag)
        {
            var newNode = SyntaxFactory.MarkupTagHelperElement(startTag, body, endTag);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupTagHelperElementSyntax WithStartTag(MarkupTagHelperStartTagSyntax startTag)
    {
        return Update(startTag, Body, EndTag);
    }

    public MarkupTagHelperElementSyntax WithBody(SyntaxList<RazorSyntaxNode> body)
    {
        return Update(StartTag, body, EndTag);
    }

    public MarkupTagHelperElementSyntax WithEndTag(MarkupTagHelperEndTagSyntax endTag)
    {
        return Update(StartTag, Body, endTag);
    }

    public MarkupTagHelperElementSyntax AddStartTagAttributes(params RazorSyntaxNode[] items)
    {
        return this.WithStartTag(this.StartTag.WithAttributes(this.StartTag.Attributes.AddRange(items)));
    }

    public MarkupTagHelperElementSyntax AddBody(params RazorSyntaxNode[] items)
    {
        return WithBody(this.Body.AddRange(items));
    }
  }

  internal sealed partial class MarkupTagHelperStartTagSyntax : MarkupSyntaxNode
  {
    private SyntaxToken _openAngle;
    private SyntaxToken _bang;
    private SyntaxToken _name;
    private SyntaxNode _attributes;
    private SyntaxToken _forwardSlash;
    private SyntaxToken _closeAngle;

    internal MarkupTagHelperStartTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenAngle 
    {
        get
        {
            return GetRedAtZero(ref _openAngle);
        }
    }

    public SyntaxToken Bang 
    {
        get
        {
            return GetRed(ref _bang, 1);
        }
    }

    public SyntaxToken Name 
    {
        get
        {
            return GetRed(ref _name, 2);
        }
    }

    public SyntaxList<RazorSyntaxNode> Attributes 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _attributes, 3));
        }
    }

    public SyntaxToken ForwardSlash 
    {
        get
        {
            return GetRed(ref _forwardSlash, 4);
        }
    }

    public SyntaxToken CloseAngle 
    {
        get
        {
            return GetRed(ref _closeAngle, 5);
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.MarkupTagHelperStartTagSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _openAngle);
            case 1: return GetRed(ref _bang, 1);
            case 2: return GetRed(ref _name, 2);
            case 3: return GetRed(ref _attributes, 3);
            case 4: return GetRed(ref _forwardSlash, 4);
            case 5: return GetRed(ref _closeAngle, 5);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _openAngle;
            case 1: return _bang;
            case 2: return _name;
            case 3: return _attributes;
            case 4: return _forwardSlash;
            case 5: return _closeAngle;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperStartTag(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperStartTag(this);
    }

    public MarkupTagHelperStartTagSyntax Update(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || bang != Bang || name != Name || attributes != Attributes || forwardSlash != ForwardSlash || closeAngle != CloseAngle || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupTagHelperStartTag(openAngle, bang, name, attributes, forwardSlash, closeAngle, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupTagHelperStartTagSyntax WithOpenAngle(SyntaxToken openAngle)
    {
        return Update(openAngle, Bang, Name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperStartTagSyntax WithBang(SyntaxToken bang)
    {
        return Update(OpenAngle, bang, Name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperStartTagSyntax WithName(SyntaxToken name)
    {
        return Update(OpenAngle, Bang, name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperStartTagSyntax WithAttributes(SyntaxList<RazorSyntaxNode> attributes)
    {
        return Update(OpenAngle, Bang, Name, attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperStartTagSyntax WithForwardSlash(SyntaxToken forwardSlash)
    {
        return Update(OpenAngle, Bang, Name, Attributes, forwardSlash, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperStartTagSyntax WithCloseAngle(SyntaxToken closeAngle)
    {
        return Update(OpenAngle, Bang, Name, Attributes, ForwardSlash, closeAngle, ChunkGenerator);
    }

    public MarkupTagHelperStartTagSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(OpenAngle, Bang, Name, Attributes, ForwardSlash, CloseAngle, chunkGenerator);
    }

    public MarkupTagHelperStartTagSyntax AddAttributes(params RazorSyntaxNode[] items)
    {
        return WithAttributes(this.Attributes.AddRange(items));
    }
  }

  internal sealed partial class MarkupTagHelperEndTagSyntax : MarkupSyntaxNode
  {
    private SyntaxToken _openAngle;
    private SyntaxToken _forwardSlash;
    private SyntaxToken _bang;
    private SyntaxToken _name;
    private MarkupMiscAttributeContentSyntax _miscAttributeContent;
    private SyntaxToken _closeAngle;

    internal MarkupTagHelperEndTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken OpenAngle 
    {
        get
        {
            return GetRedAtZero(ref _openAngle);
        }
    }

    public SyntaxToken ForwardSlash 
    {
        get
        {
            return GetRed(ref _forwardSlash, 1);
        }
    }

    public SyntaxToken Bang 
    {
        get
        {
            return GetRed(ref _bang, 2);
        }
    }

    public SyntaxToken Name 
    {
        get
        {
            return GetRed(ref _name, 3);
        }
    }

    public MarkupMiscAttributeContentSyntax MiscAttributeContent 
    {
        get
        {
            return GetRed(ref _miscAttributeContent, 4);
        }
    }

    public SyntaxToken CloseAngle 
    {
        get
        {
            return GetRed(ref _closeAngle, 5);
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.MarkupTagHelperEndTagSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _openAngle);
            case 1: return GetRed(ref _forwardSlash, 1);
            case 2: return GetRed(ref _bang, 2);
            case 3: return GetRed(ref _name, 3);
            case 4: return GetRed(ref _miscAttributeContent, 4);
            case 5: return GetRed(ref _closeAngle, 5);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _openAngle;
            case 1: return _forwardSlash;
            case 2: return _bang;
            case 3: return _name;
            case 4: return _miscAttributeContent;
            case 5: return _closeAngle;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperEndTag(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperEndTag(this);
    }

    public MarkupTagHelperEndTagSyntax Update(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || forwardSlash != ForwardSlash || bang != Bang || name != Name || miscAttributeContent != MiscAttributeContent || closeAngle != CloseAngle || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupTagHelperEndTag(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupTagHelperEndTagSyntax WithOpenAngle(SyntaxToken openAngle)
    {
        return Update(openAngle, ForwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperEndTagSyntax WithForwardSlash(SyntaxToken forwardSlash)
    {
        return Update(OpenAngle, forwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperEndTagSyntax WithBang(SyntaxToken bang)
    {
        return Update(OpenAngle, ForwardSlash, bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperEndTagSyntax WithName(SyntaxToken name)
    {
        return Update(OpenAngle, ForwardSlash, Bang, name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperEndTagSyntax WithMiscAttributeContent(MarkupMiscAttributeContentSyntax miscAttributeContent)
    {
        return Update(OpenAngle, ForwardSlash, Bang, Name, miscAttributeContent, CloseAngle, ChunkGenerator);
    }

    public MarkupTagHelperEndTagSyntax WithCloseAngle(SyntaxToken closeAngle)
    {
        return Update(OpenAngle, ForwardSlash, Bang, Name, MiscAttributeContent, closeAngle, ChunkGenerator);
    }

    public MarkupTagHelperEndTagSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(OpenAngle, ForwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, chunkGenerator);
    }

    public MarkupTagHelperEndTagSyntax AddMiscAttributeContentChildren(params RazorSyntaxNode[] items)
    {
        var _miscAttributeContent = this.MiscAttributeContent ?? SyntaxFactory.MarkupMiscAttributeContent();
        return this.WithMiscAttributeContent(_miscAttributeContent.WithChildren(_miscAttributeContent.Children.AddRange(items)));
    }
  }

  internal sealed partial class MarkupTagHelperAttributeSyntax : MarkupSyntaxNode
  {
    private MarkupTextLiteralSyntax _namePrefix;
    private MarkupTextLiteralSyntax _name;
    private MarkupTextLiteralSyntax _nameSuffix;
    private SyntaxToken _equalsToken;
    private MarkupTextLiteralSyntax _valuePrefix;
    private MarkupTagHelperAttributeValueSyntax _value;
    private MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupTagHelperAttributeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix 
    {
        get
        {
            return GetRedAtZero(ref _namePrefix);
        }
    }

    public MarkupTextLiteralSyntax Name 
    {
        get
        {
            return GetRed(ref _name, 1);
        }
    }

    public MarkupTextLiteralSyntax NameSuffix 
    {
        get
        {
            return GetRed(ref _nameSuffix, 2);
        }
    }

    public SyntaxToken EqualsToken 
    {
        get
        {
            return GetRed(ref _equalsToken, 3);
        }
    }

    public MarkupTextLiteralSyntax ValuePrefix 
    {
        get
        {
            return GetRed(ref _valuePrefix, 4);
        }
    }

    public MarkupTagHelperAttributeValueSyntax Value 
    {
        get
        {
            return GetRed(ref _value, 5);
        }
    }

    public MarkupTextLiteralSyntax ValueSuffix 
    {
        get
        {
            return GetRed(ref _valueSuffix, 6);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _namePrefix);
            case 1: return GetRed(ref _name, 1);
            case 2: return GetRed(ref _nameSuffix, 2);
            case 3: return GetRed(ref _equalsToken, 3);
            case 4: return GetRed(ref _valuePrefix, 4);
            case 5: return GetRed(ref _value, 5);
            case 6: return GetRed(ref _valueSuffix, 6);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _name;
            case 2: return _nameSuffix;
            case 3: return _equalsToken;
            case 4: return _valuePrefix;
            case 5: return _value;
            case 6: return _valueSuffix;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperAttribute(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperAttribute(this);
    }

    public MarkupTagHelperAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || name != Name || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupTagHelperAttribute(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupTagHelperAttributeSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix)
    {
        return Update(namePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperAttributeSyntax WithName(MarkupTextLiteralSyntax name)
    {
        return Update(NamePrefix, name, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperAttributeSyntax WithNameSuffix(MarkupTextLiteralSyntax nameSuffix)
    {
        return Update(NamePrefix, Name, nameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperAttributeSyntax WithEqualsToken(SyntaxToken equalsToken)
    {
        return Update(NamePrefix, Name, NameSuffix, equalsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperAttributeSyntax WithValuePrefix(MarkupTextLiteralSyntax valuePrefix)
    {
        return Update(NamePrefix, Name, NameSuffix, EqualsToken, valuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperAttributeSyntax WithValue(MarkupTagHelperAttributeValueSyntax value)
    {
        return Update(NamePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, value, ValueSuffix);
    }

    public MarkupTagHelperAttributeSyntax WithValueSuffix(MarkupTextLiteralSyntax valueSuffix)
    {
        return Update(NamePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, Value, valueSuffix);
    }

    public MarkupTagHelperAttributeSyntax AddNameLiteralTokens(params SyntaxToken[] items)
    {
        return this.WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
    }

    public MarkupTagHelperAttributeSyntax AddValueChildren(params RazorSyntaxNode[] items)
    {
        return this.WithValue(this.Value.WithChildren(this.Value.Children.AddRange(items)));
    }
  }

  internal sealed partial class MarkupMinimizedTagHelperAttributeSyntax : MarkupSyntaxNode
  {
    private MarkupTextLiteralSyntax _namePrefix;
    private MarkupTextLiteralSyntax _name;

    internal MarkupMinimizedTagHelperAttributeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix 
    {
        get
        {
            return GetRedAtZero(ref _namePrefix);
        }
    }

    public MarkupTextLiteralSyntax Name 
    {
        get
        {
            return GetRed(ref _name, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _namePrefix);
            case 1: return GetRed(ref _name, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _name;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupMinimizedTagHelperAttribute(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupMinimizedTagHelperAttribute(this);
    }

    public MarkupMinimizedTagHelperAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        if (namePrefix != NamePrefix || name != Name)
        {
            var newNode = SyntaxFactory.MarkupMinimizedTagHelperAttribute(namePrefix, name);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupMinimizedTagHelperAttributeSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix)
    {
        return Update(namePrefix, Name);
    }

    public MarkupMinimizedTagHelperAttributeSyntax WithName(MarkupTextLiteralSyntax name)
    {
        return Update(NamePrefix, name);
    }

    public MarkupMinimizedTagHelperAttributeSyntax AddNameLiteralTokens(params SyntaxToken[] items)
    {
        return this.WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
    }
  }

  internal sealed partial class MarkupTagHelperAttributeValueSyntax : RazorBlockSyntax
  {
    private SyntaxNode _children;

    internal MarkupTagHelperAttributeValueSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _children);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperAttributeValue(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperAttributeValue(this);
    }

    public MarkupTagHelperAttributeValueSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupTagHelperAttributeValue(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new MarkupTagHelperAttributeValueSyntax WithChildren(SyntaxList<RazorSyntaxNode> children)
    {
        return Update(children);
    }
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new MarkupTagHelperAttributeValueSyntax AddChildren(params RazorSyntaxNode[] items)
    {
        return WithChildren(this.Children.AddRange(items));
    }
  }

  internal sealed partial class MarkupTagHelperDirectiveAttributeSyntax : MarkupSyntaxNode
  {
    private MarkupTextLiteralSyntax _namePrefix;
    private RazorMetaCodeSyntax _transition;
    private MarkupTextLiteralSyntax _name;
    private RazorMetaCodeSyntax _colon;
    private MarkupTextLiteralSyntax _parameterName;
    private MarkupTextLiteralSyntax _nameSuffix;
    private SyntaxToken _equalsToken;
    private MarkupTextLiteralSyntax _valuePrefix;
    private MarkupTagHelperAttributeValueSyntax _value;
    private MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupTagHelperDirectiveAttributeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix 
    {
        get
        {
            return GetRedAtZero(ref _namePrefix);
        }
    }

    public RazorMetaCodeSyntax Transition 
    {
        get
        {
            return GetRed(ref _transition, 1);
        }
    }

    public MarkupTextLiteralSyntax Name 
    {
        get
        {
            return GetRed(ref _name, 2);
        }
    }

    public RazorMetaCodeSyntax Colon 
    {
        get
        {
            return GetRed(ref _colon, 3);
        }
    }

    public MarkupTextLiteralSyntax ParameterName 
    {
        get
        {
            return GetRed(ref _parameterName, 4);
        }
    }

    public MarkupTextLiteralSyntax NameSuffix 
    {
        get
        {
            return GetRed(ref _nameSuffix, 5);
        }
    }

    public SyntaxToken EqualsToken 
    {
        get
        {
            return GetRed(ref _equalsToken, 6);
        }
    }

    public MarkupTextLiteralSyntax ValuePrefix 
    {
        get
        {
            return GetRed(ref _valuePrefix, 7);
        }
    }

    public MarkupTagHelperAttributeValueSyntax Value 
    {
        get
        {
            return GetRed(ref _value, 8);
        }
    }

    public MarkupTextLiteralSyntax ValueSuffix 
    {
        get
        {
            return GetRed(ref _valueSuffix, 9);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _namePrefix);
            case 1: return GetRed(ref _transition, 1);
            case 2: return GetRed(ref _name, 2);
            case 3: return GetRed(ref _colon, 3);
            case 4: return GetRed(ref _parameterName, 4);
            case 5: return GetRed(ref _nameSuffix, 5);
            case 6: return GetRed(ref _equalsToken, 6);
            case 7: return GetRed(ref _valuePrefix, 7);
            case 8: return GetRed(ref _value, 8);
            case 9: return GetRed(ref _valueSuffix, 9);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _transition;
            case 2: return _name;
            case 3: return _colon;
            case 4: return _parameterName;
            case 5: return _nameSuffix;
            case 6: return _equalsToken;
            case 7: return _valuePrefix;
            case 8: return _value;
            case 9: return _valueSuffix;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperDirectiveAttribute(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperDirectiveAttribute(this);
    }

    public MarkupTagHelperDirectiveAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || transition != Transition || name != Name || colon != Colon || parameterName != ParameterName || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix)
    {
        return Update(namePrefix, Transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithTransition(RazorMetaCodeSyntax transition)
    {
        return Update(NamePrefix, transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithName(MarkupTextLiteralSyntax name)
    {
        return Update(NamePrefix, Transition, name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithColon(RazorMetaCodeSyntax colon)
    {
        return Update(NamePrefix, Transition, Name, colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithParameterName(MarkupTextLiteralSyntax parameterName)
    {
        return Update(NamePrefix, Transition, Name, Colon, parameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithNameSuffix(MarkupTextLiteralSyntax nameSuffix)
    {
        return Update(NamePrefix, Transition, Name, Colon, ParameterName, nameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithEqualsToken(SyntaxToken equalsToken)
    {
        return Update(NamePrefix, Transition, Name, Colon, ParameterName, NameSuffix, equalsToken, ValuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithValuePrefix(MarkupTextLiteralSyntax valuePrefix)
    {
        return Update(NamePrefix, Transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, valuePrefix, Value, ValueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithValue(MarkupTagHelperAttributeValueSyntax value)
    {
        return Update(NamePrefix, Transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, value, ValueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithValueSuffix(MarkupTextLiteralSyntax valueSuffix)
    {
        return Update(NamePrefix, Transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, valueSuffix);
    }

    public MarkupTagHelperDirectiveAttributeSyntax AddTransitionMetaCode(params SyntaxToken[] items)
    {
        return this.WithTransition(this.Transition.WithMetaCode(this.Transition.MetaCode.AddRange(items)));
    }

    public MarkupTagHelperDirectiveAttributeSyntax AddNameLiteralTokens(params SyntaxToken[] items)
    {
        return this.WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
    }

    public MarkupTagHelperDirectiveAttributeSyntax AddValueChildren(params RazorSyntaxNode[] items)
    {
        return this.WithValue(this.Value.WithChildren(this.Value.Children.AddRange(items)));
    }
  }

  internal sealed partial class MarkupMinimizedTagHelperDirectiveAttributeSyntax : MarkupSyntaxNode
  {
    private MarkupTextLiteralSyntax _namePrefix;
    private RazorMetaCodeSyntax _transition;
    private MarkupTextLiteralSyntax _name;
    private RazorMetaCodeSyntax _colon;
    private MarkupTextLiteralSyntax _parameterName;

    internal MarkupMinimizedTagHelperDirectiveAttributeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix 
    {
        get
        {
            return GetRedAtZero(ref _namePrefix);
        }
    }

    public RazorMetaCodeSyntax Transition 
    {
        get
        {
            return GetRed(ref _transition, 1);
        }
    }

    public MarkupTextLiteralSyntax Name 
    {
        get
        {
            return GetRed(ref _name, 2);
        }
    }

    public RazorMetaCodeSyntax Colon 
    {
        get
        {
            return GetRed(ref _colon, 3);
        }
    }

    public MarkupTextLiteralSyntax ParameterName 
    {
        get
        {
            return GetRed(ref _parameterName, 4);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _namePrefix);
            case 1: return GetRed(ref _transition, 1);
            case 2: return GetRed(ref _name, 2);
            case 3: return GetRed(ref _colon, 3);
            case 4: return GetRed(ref _parameterName, 4);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _transition;
            case 2: return _name;
            case 3: return _colon;
            case 4: return _parameterName;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupMinimizedTagHelperDirectiveAttribute(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupMinimizedTagHelperDirectiveAttribute(this);
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
    {
        if (namePrefix != NamePrefix || transition != Transition || name != Name || colon != Colon || parameterName != ParameterName)
        {
            var newNode = SyntaxFactory.MarkupMinimizedTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix)
    {
        return Update(namePrefix, Transition, Name, Colon, ParameterName);
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithTransition(RazorMetaCodeSyntax transition)
    {
        return Update(NamePrefix, transition, Name, Colon, ParameterName);
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithName(MarkupTextLiteralSyntax name)
    {
        return Update(NamePrefix, Transition, name, Colon, ParameterName);
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithColon(RazorMetaCodeSyntax colon)
    {
        return Update(NamePrefix, Transition, Name, colon, ParameterName);
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithParameterName(MarkupTextLiteralSyntax parameterName)
    {
        return Update(NamePrefix, Transition, Name, Colon, parameterName);
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax AddTransitionMetaCode(params SyntaxToken[] items)
    {
        return this.WithTransition(this.Transition.WithMetaCode(this.Transition.MetaCode.AddRange(items)));
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax AddNameLiteralTokens(params SyntaxToken[] items)
    {
        return this.WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
    }
  }

  internal abstract partial class CSharpSyntaxNode : RazorSyntaxNode
  {
    internal CSharpSyntaxNode(GreenNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }
  }

  internal sealed partial class CSharpCodeBlockSyntax : RazorBlockSyntax
  {
    private SyntaxNode _children;

    internal CSharpCodeBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _children);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpCodeBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpCodeBlock(this);
    }

    public CSharpCodeBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.CSharpCodeBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new CSharpCodeBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children)
    {
        return Update(children);
    }
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new CSharpCodeBlockSyntax AddChildren(params RazorSyntaxNode[] items)
    {
        return WithChildren(this.Children.AddRange(items));
    }
  }

  internal sealed partial class CSharpTransitionSyntax : CSharpSyntaxNode
  {
    private SyntaxToken _transition;

    internal CSharpTransitionSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken Transition 
    {
        get
        {
            return GetRedAtZero(ref _transition);
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.CSharpTransitionSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _transition);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpTransition(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpTransition(this);
    }

    public CSharpTransitionSyntax Update(SyntaxToken transition, ISpanChunkGenerator chunkGenerator)
    {
        if (transition != Transition || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.CSharpTransition(transition, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CSharpTransitionSyntax WithTransition(SyntaxToken transition)
    {
        return Update(transition, ChunkGenerator);
    }

    public CSharpTransitionSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(Transition, chunkGenerator);
    }
  }

  internal sealed partial class CSharpStatementLiteralSyntax : CSharpSyntaxNode
  {
    private SyntaxNode _literalTokens;

    internal CSharpStatementLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<SyntaxToken> LiteralTokens 
    {
        get
        {
            return new SyntaxList<SyntaxToken>(GetRed(ref _literalTokens, 0));
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.CSharpStatementLiteralSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _literalTokens);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpStatementLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpStatementLiteral(this);
    }

    public CSharpStatementLiteralSyntax Update(SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.CSharpStatementLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CSharpStatementLiteralSyntax WithLiteralTokens(SyntaxList<SyntaxToken> literalTokens)
    {
        return Update(literalTokens, ChunkGenerator);
    }

    public CSharpStatementLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(LiteralTokens, chunkGenerator);
    }

    public CSharpStatementLiteralSyntax AddLiteralTokens(params SyntaxToken[] items)
    {
        return WithLiteralTokens(this.LiteralTokens.AddRange(items));
    }
  }

  internal sealed partial class CSharpExpressionLiteralSyntax : CSharpSyntaxNode
  {
    private SyntaxNode _literalTokens;

    internal CSharpExpressionLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<SyntaxToken> LiteralTokens 
    {
        get
        {
            return new SyntaxList<SyntaxToken>(GetRed(ref _literalTokens, 0));
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.CSharpExpressionLiteralSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _literalTokens);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpExpressionLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpExpressionLiteral(this);
    }

    public CSharpExpressionLiteralSyntax Update(SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.CSharpExpressionLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CSharpExpressionLiteralSyntax WithLiteralTokens(SyntaxList<SyntaxToken> literalTokens)
    {
        return Update(literalTokens, ChunkGenerator);
    }

    public CSharpExpressionLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(LiteralTokens, chunkGenerator);
    }

    public CSharpExpressionLiteralSyntax AddLiteralTokens(params SyntaxToken[] items)
    {
        return WithLiteralTokens(this.LiteralTokens.AddRange(items));
    }
  }

  internal sealed partial class CSharpEphemeralTextLiteralSyntax : CSharpSyntaxNode
  {
    private SyntaxNode _literalTokens;

    internal CSharpEphemeralTextLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<SyntaxToken> LiteralTokens 
    {
        get
        {
            return new SyntaxList<SyntaxToken>(GetRed(ref _literalTokens, 0));
        }
    }

    public ISpanChunkGenerator ChunkGenerator { get { return ((InternalSyntax.CSharpEphemeralTextLiteralSyntax)Green).ChunkGenerator; } }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _literalTokens);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpEphemeralTextLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpEphemeralTextLiteral(this);
    }

    public CSharpEphemeralTextLiteralSyntax Update(SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.CSharpEphemeralTextLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CSharpEphemeralTextLiteralSyntax WithLiteralTokens(SyntaxList<SyntaxToken> literalTokens)
    {
        return Update(literalTokens, ChunkGenerator);
    }

    public CSharpEphemeralTextLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator)
    {
        return Update(LiteralTokens, chunkGenerator);
    }

    public CSharpEphemeralTextLiteralSyntax AddLiteralTokens(params SyntaxToken[] items)
    {
        return WithLiteralTokens(this.LiteralTokens.AddRange(items));
    }
  }

  internal sealed partial class CSharpTemplateBlockSyntax : RazorBlockSyntax
  {
    private SyntaxNode _children;

    internal CSharpTemplateBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children 
    {
        get
        {
            return new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _children);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpTemplateBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpTemplateBlock(this);
    }

    public CSharpTemplateBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.CSharpTemplateBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new CSharpTemplateBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children)
    {
        return Update(children);
    }
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new CSharpTemplateBlockSyntax AddChildren(params RazorSyntaxNode[] items)
    {
        return WithChildren(this.Children.AddRange(items));
    }
  }

  internal abstract partial class CSharpRazorBlockSyntax : CSharpSyntaxNode
  {
    internal CSharpRazorBlockSyntax(GreenNode green, SyntaxNode parent, int position)
      : base(green, parent, position)
    {
    }

    public abstract CSharpTransitionSyntax Transition { get; }
    public CSharpRazorBlockSyntax WithTransition(CSharpTransitionSyntax transition) => WithTransitionCore(transition);
    internal abstract CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition);

    public abstract CSharpSyntaxNode Body { get; }
    public CSharpRazorBlockSyntax WithBody(CSharpSyntaxNode body) => WithBodyCore(body);
    internal abstract CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body);
  }

  internal sealed partial class CSharpStatementSyntax : CSharpRazorBlockSyntax
  {
    private CSharpTransitionSyntax _transition;
    private CSharpSyntaxNode _body;

    internal CSharpStatementSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override CSharpTransitionSyntax Transition 
    {
        get
        {
            return GetRedAtZero(ref _transition);
        }
    }

    public override CSharpSyntaxNode Body 
    {
        get
        {
            return GetRed(ref _body, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _transition);
            case 1: return GetRed(ref _body, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            case 1: return _body;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpStatement(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpStatement(this);
    }

    public CSharpStatementSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpStatement(transition, body);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition) => WithTransition(transition);
    public new CSharpStatementSyntax WithTransition(CSharpTransitionSyntax transition)
    {
        return Update(transition, Body);
    }

    internal override CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body) => WithBody(body);
    public new CSharpStatementSyntax WithBody(CSharpSyntaxNode body)
    {
        return Update(Transition, body);
    }
  }

  internal sealed partial class CSharpStatementBodySyntax : CSharpSyntaxNode
  {
    private RazorMetaCodeSyntax _openBrace;
    private CSharpCodeBlockSyntax _cSharpCode;
    private RazorMetaCodeSyntax _closeBrace;

    internal CSharpStatementBodySyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public RazorMetaCodeSyntax OpenBrace 
    {
        get
        {
            return GetRedAtZero(ref _openBrace);
        }
    }

    public CSharpCodeBlockSyntax CSharpCode 
    {
        get
        {
            return GetRed(ref _cSharpCode, 1);
        }
    }

    public RazorMetaCodeSyntax CloseBrace 
    {
        get
        {
            return GetRed(ref _closeBrace, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _openBrace);
            case 1: return GetRed(ref _cSharpCode, 1);
            case 2: return GetRed(ref _closeBrace, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _openBrace;
            case 1: return _cSharpCode;
            case 2: return _closeBrace;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpStatementBody(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpStatementBody(this);
    }

    public CSharpStatementBodySyntax Update(RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeBrace)
    {
        if (openBrace != OpenBrace || cSharpCode != CSharpCode || closeBrace != CloseBrace)
        {
            var newNode = SyntaxFactory.CSharpStatementBody(openBrace, cSharpCode, closeBrace);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CSharpStatementBodySyntax WithOpenBrace(RazorMetaCodeSyntax openBrace)
    {
        return Update(openBrace, CSharpCode, CloseBrace);
    }

    public CSharpStatementBodySyntax WithCSharpCode(CSharpCodeBlockSyntax cSharpCode)
    {
        return Update(OpenBrace, cSharpCode, CloseBrace);
    }

    public CSharpStatementBodySyntax WithCloseBrace(RazorMetaCodeSyntax closeBrace)
    {
        return Update(OpenBrace, CSharpCode, closeBrace);
    }

    public CSharpStatementBodySyntax AddOpenBraceMetaCode(params SyntaxToken[] items)
    {
        return this.WithOpenBrace(this.OpenBrace.WithMetaCode(this.OpenBrace.MetaCode.AddRange(items)));
    }

    public CSharpStatementBodySyntax AddCSharpCodeChildren(params RazorSyntaxNode[] items)
    {
        return this.WithCSharpCode(this.CSharpCode.WithChildren(this.CSharpCode.Children.AddRange(items)));
    }

    public CSharpStatementBodySyntax AddCloseBraceMetaCode(params SyntaxToken[] items)
    {
        return this.WithCloseBrace(this.CloseBrace.WithMetaCode(this.CloseBrace.MetaCode.AddRange(items)));
    }
  }

  internal sealed partial class CSharpExplicitExpressionSyntax : CSharpRazorBlockSyntax
  {
    private CSharpTransitionSyntax _transition;
    private CSharpSyntaxNode _body;

    internal CSharpExplicitExpressionSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override CSharpTransitionSyntax Transition 
    {
        get
        {
            return GetRedAtZero(ref _transition);
        }
    }

    public override CSharpSyntaxNode Body 
    {
        get
        {
            return GetRed(ref _body, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _transition);
            case 1: return GetRed(ref _body, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            case 1: return _body;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpExplicitExpression(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpExplicitExpression(this);
    }

    public CSharpExplicitExpressionSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpExplicitExpression(transition, body);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition) => WithTransition(transition);
    public new CSharpExplicitExpressionSyntax WithTransition(CSharpTransitionSyntax transition)
    {
        return Update(transition, Body);
    }

    internal override CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body) => WithBody(body);
    public new CSharpExplicitExpressionSyntax WithBody(CSharpSyntaxNode body)
    {
        return Update(Transition, body);
    }
  }

  internal sealed partial class CSharpExplicitExpressionBodySyntax : CSharpSyntaxNode
  {
    private RazorMetaCodeSyntax _openParen;
    private CSharpCodeBlockSyntax _cSharpCode;
    private RazorMetaCodeSyntax _closeParen;

    internal CSharpExplicitExpressionBodySyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public RazorMetaCodeSyntax OpenParen 
    {
        get
        {
            return GetRedAtZero(ref _openParen);
        }
    }

    public CSharpCodeBlockSyntax CSharpCode 
    {
        get
        {
            return GetRed(ref _cSharpCode, 1);
        }
    }

    public RazorMetaCodeSyntax CloseParen 
    {
        get
        {
            return GetRed(ref _closeParen, 2);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _openParen);
            case 1: return GetRed(ref _cSharpCode, 1);
            case 2: return GetRed(ref _closeParen, 2);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _openParen;
            case 1: return _cSharpCode;
            case 2: return _closeParen;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpExplicitExpressionBody(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpExplicitExpressionBody(this);
    }

    public CSharpExplicitExpressionBodySyntax Update(RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeParen)
    {
        if (openParen != OpenParen || cSharpCode != CSharpCode || closeParen != CloseParen)
        {
            var newNode = SyntaxFactory.CSharpExplicitExpressionBody(openParen, cSharpCode, closeParen);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CSharpExplicitExpressionBodySyntax WithOpenParen(RazorMetaCodeSyntax openParen)
    {
        return Update(openParen, CSharpCode, CloseParen);
    }

    public CSharpExplicitExpressionBodySyntax WithCSharpCode(CSharpCodeBlockSyntax cSharpCode)
    {
        return Update(OpenParen, cSharpCode, CloseParen);
    }

    public CSharpExplicitExpressionBodySyntax WithCloseParen(RazorMetaCodeSyntax closeParen)
    {
        return Update(OpenParen, CSharpCode, closeParen);
    }

    public CSharpExplicitExpressionBodySyntax AddOpenParenMetaCode(params SyntaxToken[] items)
    {
        return this.WithOpenParen(this.OpenParen.WithMetaCode(this.OpenParen.MetaCode.AddRange(items)));
    }

    public CSharpExplicitExpressionBodySyntax AddCSharpCodeChildren(params RazorSyntaxNode[] items)
    {
        return this.WithCSharpCode(this.CSharpCode.WithChildren(this.CSharpCode.Children.AddRange(items)));
    }

    public CSharpExplicitExpressionBodySyntax AddCloseParenMetaCode(params SyntaxToken[] items)
    {
        return this.WithCloseParen(this.CloseParen.WithMetaCode(this.CloseParen.MetaCode.AddRange(items)));
    }
  }

  internal sealed partial class CSharpImplicitExpressionSyntax : CSharpRazorBlockSyntax
  {
    private CSharpTransitionSyntax _transition;
    private CSharpSyntaxNode _body;

    internal CSharpImplicitExpressionSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override CSharpTransitionSyntax Transition 
    {
        get
        {
            return GetRedAtZero(ref _transition);
        }
    }

    public override CSharpSyntaxNode Body 
    {
        get
        {
            return GetRed(ref _body, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _transition);
            case 1: return GetRed(ref _body, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            case 1: return _body;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpImplicitExpression(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpImplicitExpression(this);
    }

    public CSharpImplicitExpressionSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpImplicitExpression(transition, body);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition) => WithTransition(transition);
    public new CSharpImplicitExpressionSyntax WithTransition(CSharpTransitionSyntax transition)
    {
        return Update(transition, Body);
    }

    internal override CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body) => WithBody(body);
    public new CSharpImplicitExpressionSyntax WithBody(CSharpSyntaxNode body)
    {
        return Update(Transition, body);
    }
  }

  internal sealed partial class CSharpImplicitExpressionBodySyntax : CSharpSyntaxNode
  {
    private CSharpCodeBlockSyntax _cSharpCode;

    internal CSharpImplicitExpressionBodySyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public CSharpCodeBlockSyntax CSharpCode 
    {
        get
        {
            return GetRedAtZero(ref _cSharpCode);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _cSharpCode);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _cSharpCode;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpImplicitExpressionBody(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpImplicitExpressionBody(this);
    }

    public CSharpImplicitExpressionBodySyntax Update(CSharpCodeBlockSyntax cSharpCode)
    {
        if (cSharpCode != CSharpCode)
        {
            var newNode = SyntaxFactory.CSharpImplicitExpressionBody(cSharpCode);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public CSharpImplicitExpressionBodySyntax WithCSharpCode(CSharpCodeBlockSyntax cSharpCode)
    {
        return Update(cSharpCode);
    }

    public CSharpImplicitExpressionBodySyntax AddCSharpCodeChildren(params RazorSyntaxNode[] items)
    {
        return this.WithCSharpCode(this.CSharpCode.WithChildren(this.CSharpCode.Children.AddRange(items)));
    }
  }

  internal sealed partial class RazorDirectiveSyntax : CSharpRazorBlockSyntax
  {
    private CSharpTransitionSyntax _transition;
    private CSharpSyntaxNode _body;

    internal RazorDirectiveSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override CSharpTransitionSyntax Transition 
    {
        get
        {
            return GetRedAtZero(ref _transition);
        }
    }

    public override CSharpSyntaxNode Body 
    {
        get
        {
            return GetRed(ref _body, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _transition);
            case 1: return GetRed(ref _body, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            case 1: return _body;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorDirective(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorDirective(this);
    }

    public RazorDirectiveSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.RazorDirective(transition, body);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    internal override CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition) => WithTransition(transition);
    public new RazorDirectiveSyntax WithTransition(CSharpTransitionSyntax transition)
    {
        return Update(transition, Body);
    }

    internal override CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body) => WithBody(body);
    public new RazorDirectiveSyntax WithBody(CSharpSyntaxNode body)
    {
        return Update(Transition, body);
    }
  }

  internal sealed partial class RazorDirectiveBodySyntax : CSharpSyntaxNode
  {
    private RazorSyntaxNode _keyword;
    private CSharpCodeBlockSyntax _cSharpCode;

    internal RazorDirectiveBodySyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public RazorSyntaxNode Keyword 
    {
        get
        {
            return GetRedAtZero(ref _keyword);
        }
    }

    public CSharpCodeBlockSyntax CSharpCode 
    {
        get
        {
            return GetRed(ref _cSharpCode, 1);
        }
    }

    internal override SyntaxNode GetNodeSlot(int index)
    {
        switch (index)
        {
            case 0: return GetRedAtZero(ref _keyword);
            case 1: return GetRed(ref _cSharpCode, 1);
            default: return null;
        }
    }
    internal override SyntaxNode GetCachedSlot(int index)
    {
        switch (index)
        {
            case 0: return _keyword;
            case 1: return _cSharpCode;
            default: return null;
        }
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorDirectiveBody(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorDirectiveBody(this);
    }

    public RazorDirectiveBodySyntax Update(RazorSyntaxNode keyword, CSharpCodeBlockSyntax cSharpCode)
    {
        if (keyword != Keyword || cSharpCode != CSharpCode)
        {
            var newNode = SyntaxFactory.RazorDirectiveBody(keyword, cSharpCode);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
               newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               return newNode.WithAnnotations(annotations);
            return newNode;
        }

        return this;
    }

    public RazorDirectiveBodySyntax WithKeyword(RazorSyntaxNode keyword)
    {
        return Update(keyword, CSharpCode);
    }

    public RazorDirectiveBodySyntax WithCSharpCode(CSharpCodeBlockSyntax cSharpCode)
    {
        return Update(Keyword, cSharpCode);
    }

    public RazorDirectiveBodySyntax AddCSharpCodeChildren(params RazorSyntaxNode[] items)
    {
        var _cSharpCode = this.CSharpCode ?? SyntaxFactory.CSharpCodeBlock();
        return this.WithCSharpCode(_cSharpCode.WithChildren(_cSharpCode.Children.AddRange(items)));
    }
  }
}
