*
* $Id: cinema.F,v 1.1.1.1 1995/10/24 10:21:03 cernlib Exp $
*
* $Log: cinema.F,v $
* Revision 1.1.1.1  1995/10/24 10:21:03  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/02 29/03/94  15.41.39  by  S.Giani
*-- Author :
      FUNCTION CINEMA(EK1)
C
C *** INELASTICITY IN NUCLEAR INTERACTIONS AS A FUNCTION ***
C *** OF ATOMIC NUMBER ATNO2 AND KINETIC ENERGY EK1 ***
C *** NVE 12-JUL-1988 CERN GENEVA ***
C
C ORIGIN : H.FESEFELDT (14-OCT-1987)
C
C THE FUNCTIONAL DEPENDENCE AND THE PARAMETERS HAVE BEEN OBTAINED
C BY STUDY OF VARIOUS NUCLEAR STRUCTURE MODELS.
C BUT: IT IS OF COURSE AN INTERPOLATION AS FUNCTION OF ATOMIC
C      NUMBER, FOR CERTAIN NUCLEI A DIFFERENT DESCRIPTION MAY BE
C      MORE ADEQUATE. DETAILED TESTS HAVE BEEN PERFORMED FOR
C      FE, CU, PB ,U AND SOME MIXTURES LIKE NAI, BGO, CONCRETE.
C
#include "geant321/mxgkgh.inc"
#include "geant321/s_curpar.inc"
#include "geant321/s_result.inc"
#include "geant321/s_mat.inc"
#include "geant321/limits.inc"
C
      CINEMA=0.0
      ND=IND+1
      ALA=LOG(ATNO2)
      ALEK1=LOG(EK1)
      SIG1=0.50
      SIG2=0.50
      EM=0.2390+0.0408*ALA**2
      IF (EM. GT. 1.0) EM=1.0
      CINEM=0.0019*ALA**3
      IF(CINEM.GT.0.15) CINEM=0.15
      IF (PARMAT(ND,10) .GE. 0.01) CINEM=CINEM*PARMAT(ND,10)
C
      IF (ALEK1 .GT. EM) GO TO 1
C
      CORR=-(ALEK1-EM)**2/(2.0*SIG1**2)
      IF (CORR .LT. EXPXL) CORR=EXPXL
      IF (CORR .GT. EXPXU) CORR=EXPXU
      DUM1=-EK1*CINEM
      DUM2=ABS(DUM1)
      DUM3=EXP(CORR)
      CINEMA=0.0
      IF (DUM2 .GE. 1.0) CINEMA=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GT. 1.0E-10)) CINEMA=DUM1*DUM3
      GO TO 2
C
 1    CONTINUE
      CORR=-(ALEK1-EM)**2/(2.0*SIG2**2)
      IF (CORR .LT. EXPXL) CORR=EXPXL
      IF (CORR .GT. EXPXU) CORR=EXPXU
      DUM1=-EK1*CINEM
      DUM2=ABS(DUM1)
      DUM3=EXP(CORR)
      CINEMA=0.0
      IF (DUM2 .GE. 1.0) CINEMA=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GT. 1.0E-10)) CINEMA=DUM1*DUM3
C
 2    CONTINUE
      IF (CINEMA .LT. -EK1) CINEMA=-EK1
C
      END
