// Names from https://en.wikipedia.org/wiki/X11_color_names
#include "core/map.h"

static Map<String, Color> _named_colors;
static void _populate_named_colors() {
	if (!_named_colors.empty()) {
		return;
	}
	_named_colors.insert("aliceblue", Color::hex(0xF0F8FFFF));
	_named_colors.insert("antiquewhite", Color::hex(0xFAEBD7FF));
	_named_colors.insert("aqua", Color::hex(0x00FFFFFF));
	_named_colors.insert("aquamarine", Color::hex(0x7FFFD4FF));
	_named_colors.insert("azure", Color::hex(0xF0FFFFFF));
	_named_colors.insert("beige", Color::hex(0xF5F5DCFF));
	_named_colors.insert("bisque", Color::hex(0xFFE4C4FF));
	_named_colors.insert("black", Color::hex(0x000000FF));
	_named_colors.insert("blanchedalmond", Color::hex(0xFFEBCDFF));
	_named_colors.insert("blue", Color::hex(0x0000FFFF));
	_named_colors.insert("blueviolet", Color::hex(0x8A2BE2FF));
	_named_colors.insert("brown", Color::hex(0xA52A2AFF));
	_named_colors.insert("burlywood", Color::hex(0xDEB887FF));
	_named_colors.insert("cadetblue", Color::hex(0x5F9EA0FF));
	_named_colors.insert("chartreuse", Color::hex(0x7FFF00FF));
	_named_colors.insert("chocolate", Color::hex(0xD2691EFF));
	_named_colors.insert("coral", Color::hex(0xFF7F50FF));
	_named_colors.insert("cornflower", Color::hex(0x6495EDFF));
	_named_colors.insert("cornsilk", Color::hex(0xFFF8DCFF));
	_named_colors.insert("crimson", Color::hex(0xDC143CFF));
	_named_colors.insert("cyan", Color::hex(0x00FFFFFF));
	_named_colors.insert("darkblue", Color::hex(0x00008BFF));
	_named_colors.insert("darkcyan", Color::hex(0x008B8BFF));
	_named_colors.insert("darkgoldenrod", Color::hex(0xB8860BFF));
	_named_colors.insert("darkgray", Color::hex(0xA9A9A9FF));
	_named_colors.insert("darkgreen", Color::hex(0x006400FF));
	_named_colors.insert("darkkhaki", Color::hex(0xBDB76BFF));
	_named_colors.insert("darkmagenta", Color::hex(0x8B008BFF));
	_named_colors.insert("darkolivegreen", Color::hex(0x556B2FFF));
	_named_colors.insert("darkorange", Color::hex(0xFF8C00FF));
	_named_colors.insert("darkorchid", Color::hex(0x9932CCFF));
	_named_colors.insert("darkred", Color::hex(0x8B0000FF));
	_named_colors.insert("darksalmon", Color::hex(0xE9967AFF));
	_named_colors.insert("darkseagreen", Color::hex(0x8FBC8FFF));
	_named_colors.insert("darkslateblue", Color::hex(0x483D8BFF));
	_named_colors.insert("darkslategray", Color::hex(0x2F4F4FFF));
	_named_colors.insert("darkturquoise", Color::hex(0x00CED1FF));
	_named_colors.insert("darkviolet", Color::hex(0x9400D3FF));
	_named_colors.insert("deeppink", Color::hex(0xFF1493FF));
	_named_colors.insert("deepskyblue", Color::hex(0x00BFFFFF));
	_named_colors.insert("dimgray", Color::hex(0x696969FF));
	_named_colors.insert("dodgerblue", Color::hex(0x1E90FFFF));
	_named_colors.insert("firebrick", Color::hex(0xB22222FF));
	_named_colors.insert("floralwhite", Color::hex(0xFFFAF0FF));
	_named_colors.insert("forestgreen", Color::hex(0x228B22FF));
	_named_colors.insert("fuchsia", Color::hex(0xFF00FFFF));
	_named_colors.insert("gainsboro", Color::hex(0xDCDCDCFF));
	_named_colors.insert("ghostwhite", Color::hex(0xF8F8FFFF));
	_named_colors.insert("gold", Color::hex(0xFFD700FF));
	_named_colors.insert("goldenrod", Color::hex(0xDAA520FF));
	_named_colors.insert("gray", Color::hex(0xBEBEBEFF));
	_named_colors.insert("green", Color::hex(0x00FF00FF));
	_named_colors.insert("greenyellow", Color::hex(0xADFF2FFF));
	_named_colors.insert("honeydew", Color::hex(0xF0FFF0FF));
	_named_colors.insert("hotpink", Color::hex(0xFF69B4FF));
	_named_colors.insert("indianred", Color::hex(0xCD5C5CFF));
	_named_colors.insert("indigo", Color::hex(0x4B0082FF));
	_named_colors.insert("ivory", Color::hex(0xFFFFF0FF));
	_named_colors.insert("khaki", Color::hex(0xF0E68CFF));
	_named_colors.insert("lavender", Color::hex(0xE6E6FAFF));
	_named_colors.insert("lavenderblush", Color::hex(0xFFF0F5FF));
	_named_colors.insert("lawngreen", Color::hex(0x7CFC00FF));
	_named_colors.insert("lemonchiffon", Color::hex(0xFFFACDFF));
	_named_colors.insert("lightblue", Color::hex(0xADD8E6FF));
	_named_colors.insert("lightcoral", Color::hex(0xF08080FF));
	_named_colors.insert("lightcyan", Color::hex(0xE0FFFFFF));
	_named_colors.insert("lightgoldenrod", Color::hex(0xFAFAD2FF));
	_named_colors.insert("lightgray", Color::hex(0xD3D3D3FF));
	_named_colors.insert("lightgreen", Color::hex(0x90EE90FF));
	_named_colors.insert("lightpink", Color::hex(0xFFB6C1FF));
	_named_colors.insert("lightsalmon", Color::hex(0xFFA07AFF));
	_named_colors.insert("lightseagreen", Color::hex(0x20B2AAFF));
	_named_colors.insert("lightskyblue", Color::hex(0x87CEFAFF));
	_named_colors.insert("lightslategray", Color::hex(0x778899FF));
	_named_colors.insert("lightsteelblue", Color::hex(0xB0C4DEFF));
	_named_colors.insert("lightyellow", Color::hex(0xFFFFE0FF));
	_named_colors.insert("lime", Color::hex(0x00FF00FF));
	_named_colors.insert("limegreen", Color::hex(0x32CD32FF));
	_named_colors.insert("linen", Color::hex(0xFAF0E6FF));
	_named_colors.insert("magenta", Color::hex(0xFF00FFFF));
	_named_colors.insert("maroon", Color::hex(0xB03060FF));
	_named_colors.insert("mediumaquamarine", Color::hex(0x66CDAAFF));
	_named_colors.insert("mediumblue", Color::hex(0x0000CDFF));
	_named_colors.insert("mediumorchid", Color::hex(0xBA55D3FF));
	_named_colors.insert("mediumpurple", Color::hex(0x9370DBFF));
	_named_colors.insert("mediumseagreen", Color::hex(0x3CB371FF));
	_named_colors.insert("mediumslateblue", Color::hex(0x7B68EEFF));
	_named_colors.insert("mediumspringgreen", Color::hex(0x00FA9AFF));
	_named_colors.insert("mediumturquoise", Color::hex(0x48D1CCFF));
	_named_colors.insert("mediumvioletred", Color::hex(0xC71585FF));
	_named_colors.insert("midnightblue", Color::hex(0x191970FF));
	_named_colors.insert("mintcream", Color::hex(0xF5FFFAFF));
	_named_colors.insert("mistyrose", Color::hex(0xFFE4E1FF));
	_named_colors.insert("moccasin", Color::hex(0xFFE4B5FF));
	_named_colors.insert("navajowhite", Color::hex(0xFFDEADFF));
	_named_colors.insert("navyblue", Color::hex(0x000080FF));
	_named_colors.insert("oldlace", Color::hex(0xFDF5E6FF));
	_named_colors.insert("olive", Color::hex(0x808000FF));
	_named_colors.insert("olivedrab", Color::hex(0x6B8E23FF));
	_named_colors.insert("orange", Color::hex(0xFFA500FF));
	_named_colors.insert("orangered", Color::hex(0xFF4500FF));
	_named_colors.insert("orchid", Color::hex(0xDA70D6FF));
	_named_colors.insert("palegoldenrod", Color::hex(0xEEE8AAFF));
	_named_colors.insert("palegreen", Color::hex(0x98FB98FF));
	_named_colors.insert("paleturquoise", Color::hex(0xAFEEEEFF));
	_named_colors.insert("palevioletred", Color::hex(0xDB7093FF));
	_named_colors.insert("papayawhip", Color::hex(0xFFEFD5FF));
	_named_colors.insert("peachpuff", Color::hex(0xFFDAB9FF));
	_named_colors.insert("peru", Color::hex(0xCD853FFF));
	_named_colors.insert("pink", Color::hex(0xFFC0CBFF));
	_named_colors.insert("plum", Color::hex(0xDDA0DDFF));
	_named_colors.insert("powderblue", Color::hex(0xB0E0E6FF));
	_named_colors.insert("purple", Color::hex(0xA020F0FF));
	_named_colors.insert("rebeccapurple", Color::hex(0x663399FF));
	_named_colors.insert("red", Color::hex(0xFF0000FF));
	_named_colors.insert("rosybrown", Color::hex(0xBC8F8FFF));
	_named_colors.insert("royalblue", Color::hex(0x4169E1FF));
	_named_colors.insert("saddlebrown", Color::hex(0x8B4513FF));
	_named_colors.insert("salmon", Color::hex(0xFA8072FF));
	_named_colors.insert("sandybrown", Color::hex(0xF4A460FF));
	_named_colors.insert("seagreen", Color::hex(0x2E8B57FF));
	_named_colors.insert("seashell", Color::hex(0xFFF5EEFF));
	_named_colors.insert("sienna", Color::hex(0xA0522DFF));
	_named_colors.insert("silver", Color::hex(0xC0C0C0FF));
	_named_colors.insert("skyblue", Color::hex(0x87CEEBFF));
	_named_colors.insert("slateblue", Color::hex(0x6A5ACDFF));
	_named_colors.insert("slategray", Color::hex(0x708090FF));
	_named_colors.insert("snow", Color::hex(0xFFFAFAFF));
	_named_colors.insert("springgreen", Color::hex(0x00FF7FFF));
	_named_colors.insert("steelblue", Color::hex(0x4682B4FF));
	_named_colors.insert("tan", Color::hex(0xD2B48CFF));
	_named_colors.insert("teal", Color::hex(0x008080FF));
	_named_colors.insert("thistle", Color::hex(0xD8BFD8FF));
	_named_colors.insert("tomato", Color::hex(0xFF6347FF));
	_named_colors.insert("transparent", Color::hex(0xFFFFFF00));
	_named_colors.insert("turquoise", Color::hex(0x40E0D0FF));
	_named_colors.insert("violet", Color::hex(0xEE82EEFF));
	_named_colors.insert("webgray", Color::hex(0x808080FF));
	_named_colors.insert("webgreen", Color::hex(0x008000FF));
	_named_colors.insert("webmaroon", Color::hex(0x800000FF));
	_named_colors.insert("webpurple", Color::hex(0x800080FF));
	_named_colors.insert("wheat", Color::hex(0xF5DEB3FF));
	_named_colors.insert("white", Color::hex(0xFFFFFFFF));
	_named_colors.insert("whitesmoke", Color::hex(0xF5F5F5FF));
	_named_colors.insert("yellow", Color::hex(0xFFFF00FF));
	_named_colors.insert("yellowgreen", Color::hex(0x9ACD32FF));
}
