// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/event_service.proto

package talent

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The report event request.
type CreateClientEventRequest struct {
	// Required. Resource name of the tenant under which the event is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
	// is created, for example, "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Events issued when end user interacts with customer's application that
	// uses Cloud Talent Solution.
	ClientEvent          *ClientEvent `protobuf:"bytes,2,opt,name=client_event,json=clientEvent,proto3" json:"client_event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateClientEventRequest) Reset()         { *m = CreateClientEventRequest{} }
func (m *CreateClientEventRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClientEventRequest) ProtoMessage()    {}
func (*CreateClientEventRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe732bea1e1e1bea, []int{0}
}

func (m *CreateClientEventRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClientEventRequest.Unmarshal(m, b)
}
func (m *CreateClientEventRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClientEventRequest.Marshal(b, m, deterministic)
}
func (m *CreateClientEventRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClientEventRequest.Merge(m, src)
}
func (m *CreateClientEventRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClientEventRequest.Size(m)
}
func (m *CreateClientEventRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClientEventRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClientEventRequest proto.InternalMessageInfo

func (m *CreateClientEventRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateClientEventRequest) GetClientEvent() *ClientEvent {
	if m != nil {
		return m.ClientEvent
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateClientEventRequest)(nil), "google.cloud.talent.v4beta1.CreateClientEventRequest")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/event_service.proto", fileDescriptor_fe732bea1e1e1bea)
}

var fileDescriptor_fe732bea1e1e1bea = []byte{
	// 447 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xb1, 0x6e, 0x13, 0x41,
	0x10, 0x86, 0xb5, 0x17, 0x29, 0x12, 0x97, 0x34, 0xb9, 0x14, 0x98, 0x0b, 0x28, 0x91, 0x29, 0x30,
	0x51, 0xd8, 0x15, 0x09, 0x34, 0x89, 0x28, 0xce, 0x16, 0xbd, 0x65, 0x53, 0xa5, 0xb1, 0xd6, 0x97,
	0xc9, 0xf9, 0xa2, 0xf5, 0xce, 0xb2, 0x3b, 0x3e, 0x0b, 0x21, 0x84, 0x84, 0x78, 0x03, 0xde, 0x80,
	0x8e, 0x57, 0xa1, 0x84, 0x8e, 0x2a, 0x05, 0x4f, 0x11, 0x1a, 0x74, 0xb7, 0x07, 0x39, 0x91, 0x70,
	0x49, 0xb7, 0xf6, 0xfc, 0xdf, 0xfd, 0xf3, 0xcf, 0x4c, 0x28, 0x32, 0xc4, 0x4c, 0x81, 0x48, 0x15,
	0x2e, 0x4e, 0x04, 0x49, 0x05, 0x9a, 0x44, 0xf1, 0x6c, 0x0a, 0x24, 0x9f, 0x0a, 0x28, 0x40, 0xd3,
	0xc4, 0x81, 0x2d, 0xf2, 0x14, 0xb8, 0xb1, 0x48, 0x18, 0x6d, 0x79, 0x80, 0x57, 0x00, 0xf7, 0x00,
	0xaf, 0x81, 0xf8, 0x7e, 0xfd, 0x35, 0x69, 0x72, 0x21, 0xb5, 0x46, 0x92, 0x94, 0xa3, 0x76, 0x1e,
	0x8d, 0xef, 0x36, 0xaa, 0xa9, 0xca, 0x4b, 0xd0, 0x17, 0xb6, 0x1b, 0x85, 0xd3, 0x1c, 0xd4, 0xc9,
	0x64, 0x0a, 0x33, 0x59, 0xe4, 0x68, 0x6b, 0xc1, 0xbd, 0x86, 0xc0, 0x82, 0xc3, 0x85, 0xfd, 0xd3,
	0x4f, 0xfc, 0xe8, 0xc6, 0x00, 0x5e, 0xd8, 0xfd, 0xc2, 0xc2, 0xce, 0xc0, 0x82, 0x24, 0x18, 0x54,
	0xde, 0x2f, 0xcb, 0xda, 0x08, 0x5e, 0x2f, 0xc0, 0x51, 0x74, 0x14, 0xae, 0x1a, 0x69, 0x41, 0x53,
	0x87, 0xed, 0xb0, 0xde, 0x9d, 0xfe, 0xc3, 0xf3, 0x24, 0xb8, 0x48, 0x1e, 0x44, 0x5b, 0x67, 0x38,
	0x75, 0xdc, 0x5b, 0x48, 0x93, 0x3b, 0x9e, 0xe2, 0x5c, 0x0c, 0x70, 0x6e, 0xa4, 0x7e, 0x33, 0xaa,
	0x91, 0x68, 0x18, 0xae, 0xfb, 0x38, 0x93, 0xca, 0xaf, 0x13, 0xec, 0xb0, 0xde, 0xda, 0x7e, 0x8f,
	0xb7, 0x4c, 0x8a, 0x37, 0x7a, 0xe8, 0xaf, 0x9c, 0x27, 0xc1, 0x68, 0x2d, 0xbd, 0xfc, 0x67, 0xff,
	0x22, 0x08, 0xd7, 0xab, 0xd7, 0xd8, 0xcf, 0x3e, 0xfa, 0xc5, 0xc2, 0x8d, 0x2b, 0xcd, 0x47, 0xcf,
	0xdb, 0x2d, 0xfe, 0x13, 0x36, 0xbe, 0x75, 0x67, 0xdd, 0x8f, 0xec, 0x47, 0xb2, 0xe9, 0x53, 0xee,
	0x35, 0x23, 0x7e, 0xf8, 0xfe, 0xf3, 0x53, 0x30, 0xeb, 0x1e, 0xfc, 0x1d, 0xf4, 0x5b, 0x2f, 0x7a,
	0x61, 0x2c, 0x9e, 0x41, 0x4a, 0x4e, 0xec, 0x0a, 0x02, 0x2d, 0x75, 0xf9, 0x7a, 0x27, 0x1a, 0xd1,
	0xdc, 0x21, 0xdb, 0x3d, 0xe6, 0xdd, 0xc7, 0x2d, 0xe4, 0x15, 0x7d, 0xac, 0xbe, 0x26, 0x9b, 0xd7,
	0x2c, 0xe2, 0x5b, 0x32, 0x9e, 0x11, 0x19, 0x77, 0x28, 0xc4, 0x72, 0xb9, 0xfc, 0x77, 0x4b, 0x72,
	0x41, 0x33, 0x7f, 0x15, 0x4f, 0x8c, 0x92, 0x74, 0x8a, 0x76, 0xbe, 0x77, 0x93, 0xbc, 0x34, 0xe9,
	0xbf, 0x0f, 0xb7, 0x53, 0x9c, 0xb7, 0xcd, 0xa8, 0xbf, 0xd1, 0x5c, 0xce, 0xb0, 0x3c, 0xaf, 0x21,
	0x3b, 0x4e, 0x6a, 0x22, 0x43, 0x25, 0x75, 0xc6, 0xd1, 0x66, 0x22, 0x03, 0x5d, 0x1d, 0x9f, 0xb8,
	0x34, 0xbb, 0xf6, 0x50, 0x8f, 0xfc, 0xcf, 0xcf, 0xc1, 0xca, 0xe0, 0xd5, 0x78, 0xba, 0x5a, 0x31,
	0x07, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xb4, 0x51, 0x62, 0x5a, 0x9c, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EventServiceClient is the client API for EventService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EventServiceClient interface {
	// Report events issued when end user interacts with customer's application
	// that uses Cloud Talent Solution. You may inspect the created events in
	// [self service
	// tools](https://console.cloud.google.com/talent-solution/overview).
	// [Learn
	// more](https://cloud.google.com/talent-solution/docs/management-tools)
	// about self service tools.
	CreateClientEvent(ctx context.Context, in *CreateClientEventRequest, opts ...grpc.CallOption) (*ClientEvent, error)
}

type eventServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEventServiceClient(cc grpc.ClientConnInterface) EventServiceClient {
	return &eventServiceClient{cc}
}

func (c *eventServiceClient) CreateClientEvent(ctx context.Context, in *CreateClientEventRequest, opts ...grpc.CallOption) (*ClientEvent, error) {
	out := new(ClientEvent)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.EventService/CreateClientEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EventServiceServer is the server API for EventService service.
type EventServiceServer interface {
	// Report events issued when end user interacts with customer's application
	// that uses Cloud Talent Solution. You may inspect the created events in
	// [self service
	// tools](https://console.cloud.google.com/talent-solution/overview).
	// [Learn
	// more](https://cloud.google.com/talent-solution/docs/management-tools)
	// about self service tools.
	CreateClientEvent(context.Context, *CreateClientEventRequest) (*ClientEvent, error)
}

// UnimplementedEventServiceServer can be embedded to have forward compatible implementations.
type UnimplementedEventServiceServer struct {
}

func (*UnimplementedEventServiceServer) CreateClientEvent(ctx context.Context, req *CreateClientEventRequest) (*ClientEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateClientEvent not implemented")
}

func RegisterEventServiceServer(s *grpc.Server, srv EventServiceServer) {
	s.RegisterService(&_EventService_serviceDesc, srv)
}

func _EventService_CreateClientEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClientEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventServiceServer).CreateClientEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.EventService/CreateClientEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventServiceServer).CreateClientEvent(ctx, req.(*CreateClientEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EventService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.EventService",
	HandlerType: (*EventServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateClientEvent",
			Handler:    _EventService_CreateClientEvent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/event_service.proto",
}
