// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/rethinkdb/rethinkdb-go.v6"
	"gopkg.in/rethinkdb/rethinkdb-go.v6/internal/compare"
)

// Test `include_states`
func TestChangefeedsIncludeStatesSuite(t *testing.T) {
	suite.Run(t, new(ChangefeedsIncludeStatesSuite))
}

type ChangefeedsIncludeStatesSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *ChangefeedsIncludeStatesSuite) SetupTest() {
	suite.T().Log("Setting up ChangefeedsIncludeStatesSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("db_feed_include").Exec(suite.session)
	err = r.DBCreate("db_feed_include").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("db_feed_include").Wait().Exec(suite.session)
	suite.Require().NoError(err)

	r.DB("db_feed_include").TableDrop("table_test_changefeed_include").Exec(suite.session)
	err = r.DB("db_feed_include").TableCreate("table_test_changefeed_include").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("db_feed_include").Table("table_test_changefeed_include").Wait().Exec(suite.session)
	suite.Require().NoError(err)
}

func (suite *ChangefeedsIncludeStatesSuite) TearDownSuite() {
	suite.T().Log("Tearing down ChangefeedsIncludeStatesSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DB("db_feed_include").TableDrop("table_test_changefeed_include").Exec(suite.session)
		r.DBDrop("db_feed_include").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *ChangefeedsIncludeStatesSuite) TestCases() {
	suite.T().Log("Running ChangefeedsIncludeStatesSuite: Test `include_states`")

	table_test_changefeed_include := r.DB("db_feed_include").Table("table_test_changefeed_include")
	_ = table_test_changefeed_include // Prevent any noused variable errors

	{
		// changefeeds/include_states.yaml line #4
		/* [{'state':'ready'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"state": "ready"}}
		/* table_test_changefeed_include.changes(squash=true, include_states=true).limit(1) */

		suite.T().Log("About to run line #4: table_test_changefeed_include.Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true, }).Limit(1)")

		runAndAssert(suite.Suite, expected_, table_test_changefeed_include.Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true}).Limit(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #4")
	}

	{
		// changefeeds/include_states.yaml line #9
		/* [{'state':'initializing'}, {'new_val':null}, {'state':'ready'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"state": "initializing"}, map[interface{}]interface{}{"new_val": nil}, map[interface{}]interface{}{"state": "ready"}}
		/* table_test_changefeed_include.get(0).changes(squash=true, include_states=true, include_initial=true).limit(3) */

		suite.T().Log("About to run line #9: table_test_changefeed_include.Get(0).Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true, IncludeInitial: true, }).Limit(3)")

		runAndAssert(suite.Suite, expected_, table_test_changefeed_include.Get(0).Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true, IncludeInitial: true}).Limit(3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #9")
	}

	{
		// changefeeds/include_states.yaml line #14
		/* [{'state':'initializing'}, {'state':'ready'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"state": "initializing"}, map[interface{}]interface{}{"state": "ready"}}
		/* table_test_changefeed_include.order_by(index='id').limit(10).changes(squash=true, include_states=true, include_initial=true).limit(2) */

		suite.T().Log("About to run line #14: table_test_changefeed_include.OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).Limit(10).Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true, IncludeInitial: true, }).Limit(2)")

		runAndAssert(suite.Suite, expected_, table_test_changefeed_include.OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).Limit(10).Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true, IncludeInitial: true}).Limit(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #14")
	}

	{
		// changefeeds/include_states.yaml line #19
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_changefeed_include.insert({'id':1}) */

		suite.T().Log("About to run line #19: table_test_changefeed_include.Insert(map[interface{}]interface{}{'id': 1, })")

		runAndAssert(suite.Suite, expected_, table_test_changefeed_include.Insert(map[interface{}]interface{}{"id": 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #19")
	}

	{
		// changefeeds/include_states.yaml line #21
		/* [{'state':'initializing'}, {'new_val':{'id':1}}, {'state':'ready'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"state": "initializing"}, map[interface{}]interface{}{"new_val": map[interface{}]interface{}{"id": 1}}, map[interface{}]interface{}{"state": "ready"}}
		/* table_test_changefeed_include.order_by(index='id').limit(10).changes(squash=true, include_states=true, include_initial=true).limit(3) */

		suite.T().Log("About to run line #21: table_test_changefeed_include.OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).Limit(10).Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true, IncludeInitial: true, }).Limit(3)")

		runAndAssert(suite.Suite, expected_, table_test_changefeed_include.OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).Limit(10).Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true, IncludeInitial: true}).Limit(3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #21")
	}

	// changefeeds/include_states.yaml line #26
	// table_test_changefeed_includechanges = table_test_changefeed_include.changes(squash=true, include_states=true)
	suite.T().Log("Possibly executing: var table_test_changefeed_includechanges r.Term = table_test_changefeed_include.Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true, })")

	table_test_changefeed_includechanges := maybeRun(table_test_changefeed_include.Changes().OptArgs(r.ChangesOpts{Squash: true, IncludeStates: true}), suite.session, r.RunOpts{})
	_ = table_test_changefeed_includechanges // Prevent any noused variable errors

	{
		// changefeeds/include_states.yaml line #30
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_changefeed_include.insert({'id':2}) */

		suite.T().Log("About to run line #30: table_test_changefeed_include.Insert(map[interface{}]interface{}{'id': 2, })")

		runAndAssert(suite.Suite, expected_, table_test_changefeed_include.Insert(map[interface{}]interface{}{"id": 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #30")
	}

	{
		// changefeeds/include_states.yaml line #32
		/* [{'state':'ready'},{'new_val':{'id':2},'old_val':null}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"state": "ready"}, map[interface{}]interface{}{"new_val": map[interface{}]interface{}{"id": 2}, "old_val": nil}}
		/* fetch(table_test_changefeed_includechanges, 2) */

		suite.T().Log("About to run line #32: fetch(table_test_changefeed_includechanges, 2)")

		fetchAndAssert(suite.Suite, expected_, table_test_changefeed_includechanges, 2)
		suite.T().Log("Finished running line #32")
	}

	// changefeeds/include_states.yaml line #35
	// getchanges = table_test_changefeed_include.get(2).changes(include_states=true, include_initial=true)
	suite.T().Log("Possibly executing: var getchanges r.Term = table_test_changefeed_include.Get(2).Changes().OptArgs(r.ChangesOpts{IncludeStates: true, IncludeInitial: true, })")

	getchanges := maybeRun(table_test_changefeed_include.Get(2).Changes().OptArgs(r.ChangesOpts{IncludeStates: true, IncludeInitial: true}), suite.session, r.RunOpts{})
	_ = getchanges // Prevent any noused variable errors

	{
		// changefeeds/include_states.yaml line #39
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_changefeed_include.get(2).update({'a':1}) */

		suite.T().Log("About to run line #39: table_test_changefeed_include.Get(2).Update(map[interface{}]interface{}{'a': 1, })")

		runAndAssert(suite.Suite, expected_, table_test_changefeed_include.Get(2).Update(map[interface{}]interface{}{"a": 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #39")
	}

	{
		// changefeeds/include_states.yaml line #41
		/* [{'state':'initializing'}, {'new_val':{'id':2}}, {'state':'ready'}, {'old_val':{'id':2},'new_val':{'id':2,'a':1}}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"state": "initializing"}, map[interface{}]interface{}{"new_val": map[interface{}]interface{}{"id": 2}}, map[interface{}]interface{}{"state": "ready"}, map[interface{}]interface{}{"old_val": map[interface{}]interface{}{"id": 2}, "new_val": map[interface{}]interface{}{"id": 2, "a": 1}}}
		/* fetch(getchanges, 4) */

		suite.T().Log("About to run line #41: fetch(getchanges, 4)")

		fetchAndAssert(suite.Suite, expected_, getchanges, 4)
		suite.T().Log("Finished running line #41")
	}

	// changefeeds/include_states.yaml line #44
	// limitchanges = table_test_changefeed_include.order_by(index='id').limit(10).changes(include_states=true, include_initial=true)
	suite.T().Log("Possibly executing: var limitchanges r.Term = table_test_changefeed_include.OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).Limit(10).Changes().OptArgs(r.ChangesOpts{IncludeStates: true, IncludeInitial: true, })")

	limitchanges := maybeRun(table_test_changefeed_include.OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).Limit(10).Changes().OptArgs(r.ChangesOpts{IncludeStates: true, IncludeInitial: true}), suite.session, r.RunOpts{})
	_ = limitchanges // Prevent any noused variable errors

	// changefeeds/include_states.yaml line #48
	// limitchangesdesc = table_test_changefeed_include.order_by(index=r.desc('id')).limit(10).changes(include_states=true, include_initial=true)
	suite.T().Log("Possibly executing: var limitchangesdesc r.Term = table_test_changefeed_include.OrderBy().OptArgs(r.OrderByOpts{Index: r.Desc('id'), }).Limit(10).Changes().OptArgs(r.ChangesOpts{IncludeStates: true, IncludeInitial: true, })")

	limitchangesdesc := maybeRun(table_test_changefeed_include.OrderBy().OptArgs(r.OrderByOpts{Index: r.Desc("id")}).Limit(10).Changes().OptArgs(r.ChangesOpts{IncludeStates: true, IncludeInitial: true}), suite.session, r.RunOpts{})
	_ = limitchangesdesc // Prevent any noused variable errors

	{
		// changefeeds/include_states.yaml line #52
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_changefeed_include.insert({'id':3}) */

		suite.T().Log("About to run line #52: table_test_changefeed_include.Insert(map[interface{}]interface{}{'id': 3, })")

		runAndAssert(suite.Suite, expected_, table_test_changefeed_include.Insert(map[interface{}]interface{}{"id": 3}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #52")
	}

	{
		// changefeeds/include_states.yaml line #54
		/* [{'state':'initializing'}, {'new_val':{'id':1}}, {'new_val':{'a':1, 'id':2}}, {'state':'ready'}, {'old_val':null, 'new_val':{'id':3}}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"state": "initializing"}, map[interface{}]interface{}{"new_val": map[interface{}]interface{}{"id": 1}}, map[interface{}]interface{}{"new_val": map[interface{}]interface{}{"a": 1, "id": 2}}, map[interface{}]interface{}{"state": "ready"}, map[interface{}]interface{}{"old_val": nil, "new_val": map[interface{}]interface{}{"id": 3}}}
		/* fetch(limitchanges, 5) */

		suite.T().Log("About to run line #54: fetch(limitchanges, 5)")

		fetchAndAssert(suite.Suite, expected_, limitchanges, 5)
		suite.T().Log("Finished running line #54")
	}

	{
		// changefeeds/include_states.yaml line #57
		/* [{'state':'initializing'}, {'new_val':{'a':1, 'id':2}}, {'new_val':{'id':1}}, {'state':'ready'}, {'old_val':null, 'new_val':{'id':3}}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"state": "initializing"}, map[interface{}]interface{}{"new_val": map[interface{}]interface{}{"a": 1, "id": 2}}, map[interface{}]interface{}{"new_val": map[interface{}]interface{}{"id": 1}}, map[interface{}]interface{}{"state": "ready"}, map[interface{}]interface{}{"old_val": nil, "new_val": map[interface{}]interface{}{"id": 3}}}
		/* fetch(limitchangesdesc, 5) */

		suite.T().Log("About to run line #57: fetch(limitchangesdesc, 5)")

		fetchAndAssert(suite.Suite, expected_, limitchangesdesc, 5)
		suite.T().Log("Finished running line #57")
	}
}
