#!/bin/bash
# Test that the code generated by AutoFactory can run on Java 7.
# The AutoFactory processor itself runs on Java 8, but the code it
# generates is supposed to be able to run on Java 7.
#
# Users can achieve that by compiling like this:
#   javac -source 7 -target 7 -bootclasspath .../rt.jar
# where javac is the one from Java 8 or later and .../rt.jar is
# the one from Java 7. 
#
# So this test basically does the same thing, using a large functional
# test as input. If that test compiles and runs, it is a good sign
# that user code will too.

# Exit if any command fails.
set -e

# Arguments are the fully-qualified name of the test class, followed by
# the path to each source file.
TEST_CLASS="$1"
if [ -z "${TEST_CLASS}" ]; then
  echo "Usage: $0 TEST_CLASS" >&2
  exit 1
fi
shift

MY_DIR=$(dirname "${TEST_BINARY}")
SOURCE_FILES=$(for f in "$@"; do echo "${MY_DIR}/${f}"; done)

JDK8=third_party/java/jdk/jdk-64
JDK7=third_party/java/jdk/jdk7-64
JDK8_JAVAC="${JDK8}"/bin/javac
JDK7_JAVA="${JDK7}"/bin/java
CLASS_PATH="${MY_DIR}"/java7_compat_test_java_deps.jar
BOOT_PATH="${JDK7}"/jre/lib/rt.jar
PROCESSOR_PATH=\
third_party/java/auto/auto_factory_ide.jar:\
third_party/java/dagger/dagger_components_ide.jar

"${JDK8_JAVAC}" -d "${TEST_TMPDIR}" \
    -encoding utf8 -source 7 -target 7 \
    -bootclasspath "${BOOT_PATH}" \
    -classpath "${CLASS_PATH}" \
    -processorpath "${PROCESSOR_PATH}" \
    ${SOURCE_FILES}
"${JDK7_JAVA}" -classpath "${TEST_TMPDIR}:${CLASS_PATH}" \
    org.junit.runner.JUnitCore "${TEST_CLASS}"
