declare name        "WaveSharper";
declare category    "Distortion";
declare id          "distortion2";
declare description "A simple Wavesharper distortion";

import("math.lib");
import("music.lib");
import("effect.lib"); 
import("filter.lib");
import("guitarix.lib");

//----------distortion---------
bread     = highpass(2,f) : lowpass(1,6532) with {
    f     = vslider("Hfreq [log][name:HighPass (hz)][tooltip: Highpass Frequency]", 30, 20, 2000, 1.08);
};

boost     = vslider("gain [tooltip: Volume Level]", 0, -30, 10, 0.1) : db2linear : smoothi(0.999);

dist(x)   = (1+k)*(x)/(1+k*abs(x)): +~_''* 0.5 with {
    k     = 2*a/(1-a);
    a     = sin(((drive+1)/102)*(PI/2));
    drive = vslider("drive [tooltip: Distortion Level]", 50, 0, 100, 1): smoothi(0.999);
};

butter    = lowpass(2,fc) with {
    fc    = vslider("freq [log][name:freq (hz)][tooltip: Lowpass Frequency]", 10000, 1000, 20000, 1.08);
};

wet = vslider("wet_dry[name:wet/dry][tooltip:percentage of processed signal in output signal]",  100, 0, 100, 1) : /(100);
dry = 1 - wet;

process =_<:*(dry),(*(wet) : bread : *(boost) : dist : butter):>_;
