#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>
#include <syslog.h>

void error_exit(char *format, ...)
{
	char buffer[4096];
	va_list ap;

	va_start(ap, format);
	vsnprintf(buffer, sizeof(buffer), format, ap);
	va_end(ap);

	fprintf(stderr, "%s: errno=%d (if applicable)\n", buffer, errno);
	syslog(LOG_ERR, "'%s': %m", buffer);

	exit(EXIT_FAILURE);
}
