% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald_test.R
\name{Wald_test}
\alias{Wald_test}
\title{Test parameter constraints in a fitted linear regression model}
\usage{
Wald_test(obj, constraints, vcov, test = "HTZ", ...)
}
\arguments{
\item{obj}{Fitted model for which to calculate Wald tests.}

\item{constraints}{List of one or more constraints to test. See details
below.}

\item{vcov}{Variance covariance matrix estimated using \code{vcovCR} or a 
character string specifying which small-sample adjustment should be used to
calculate the variance-covariance.}

\item{test}{Character vector specifying which small-sample correction(s) to 
calculate. The following corrections are available: \code{"chi-sq"}, 
\code{"Naive-F"}, \code{"HTA"}, \code{"HTB"}, \code{"HTZ"}, \code{"EDF"}, 
\code{"EDT"}. Default is \code{"HTZ"}.}

\item{...}{Further arguments passed to \code{\link{vcovCR}}, which are only 
needed if \code{vcov} is a character string.}
}
\value{
A list of test results.
}
\description{
\code{Wald_test} reports Wald-type tests of linear contrasts from a fitted 
linear regression model, using a sandwich estimator for the 
variance-covariance matrix and a small sample correction for the p-value. 
Several different small-sample corrections are available.
}
\details{
Constraints can be specified as character vectors, integer vectors,
logical vectors, or matrices.
}
\seealso{
\code{\link{vcovCR}}
}
